/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.util;

import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.nifi.remote.PeerStatus;
import org.apache.nifi.remote.protocol.SiteToSiteTransportProtocol;

public class PeerStatusCache {
    private final Set<PeerStatus> statuses;
    private final long timestamp;
    private final String remoteInstanceUris;
    private final SiteToSiteTransportProtocol transportProtocol;

    public PeerStatusCache(Set<PeerStatus> statuses, long timestamp, String remoteInstanceUris, SiteToSiteTransportProtocol transportProtocol) {
        this.statuses = statuses;
        this.timestamp = timestamp;
        this.remoteInstanceUris = remoteInstanceUris;
        this.transportProtocol = transportProtocol;
    }

    public Set<PeerStatus> getStatuses() {
        return this.statuses;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getRemoteInstanceUris() {
        return this.remoteInstanceUris;
    }

    public SiteToSiteTransportProtocol getTransportProtocol() {
        return this.transportProtocol;
    }

    public boolean isEmpty() {
        return this.statuses == null || this.statuses.isEmpty();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("Timestamp", this.timestamp);
        builder.append("Remote instance URIs", (Object)this.remoteInstanceUris);
        builder.append("Transport protocol", (Object)this.transportProtocol);
        builder.append("Peer status count", this.statuses != null ? this.statuses.size() : 0);
        builder.append("Peer statuses", this.statuses);
        return builder.toString();
    }
}

