/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import org.aopalliance.intercept.MethodInvocation;
import org.springframework.context.ApplicationContext;
import org.springframework.expression.EvaluationContext;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.authorization.method.ExpressionAttribute;
import org.springframework.security.authorization.method.MethodAuthorizationDeniedHandler;
import org.springframework.security.authorization.method.MethodInvocationResult;
import org.springframework.security.authorization.method.PostAuthorizeExpressionAttribute;
import org.springframework.security.authorization.method.PostAuthorizeExpressionAttributeRegistry;
import org.springframework.security.authorization.method.PrePostTemplateDefaults;
import org.springframework.security.authorization.method.ReactiveExpressionUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.annotation.AnnotationTemplateExpressionDefaults;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public final class PostAuthorizeReactiveAuthorizationManager
implements ReactiveAuthorizationManager<MethodInvocationResult>,
MethodAuthorizationDeniedHandler {
    private final PostAuthorizeExpressionAttributeRegistry registry = new PostAuthorizeExpressionAttributeRegistry();

    public PostAuthorizeReactiveAuthorizationManager() {
        this(new DefaultMethodSecurityExpressionHandler());
    }

    public PostAuthorizeReactiveAuthorizationManager(MethodSecurityExpressionHandler expressionHandler) {
        Assert.notNull((Object)expressionHandler, (String)"expressionHandler cannot be null");
        this.registry.setExpressionHandler(expressionHandler);
    }

    @Deprecated
    public void setTemplateDefaults(PrePostTemplateDefaults defaults) {
        this.registry.setTemplateDefaults(defaults);
    }

    public void setTemplateDefaults(AnnotationTemplateExpressionDefaults defaults) {
        this.registry.setTemplateDefaults(defaults);
    }

    public void setApplicationContext(ApplicationContext context) {
        this.registry.setApplicationContext(context);
    }

    @Override
    public Mono<AuthorizationDecision> check(Mono<Authentication> authentication, MethodInvocationResult result) {
        MethodInvocation mi = result.getMethodInvocation();
        Object attribute = this.registry.getAttribute(mi);
        if (attribute == ExpressionAttribute.NULL_ATTRIBUTE) {
            return Mono.empty();
        }
        MethodSecurityExpressionHandler expressionHandler = this.registry.getExpressionHandler();
        return authentication.map(auth -> expressionHandler.createEvaluationContext((Authentication)auth, mi)).doOnNext(ctx -> expressionHandler.setReturnObject(result.getResult(), (EvaluationContext)ctx)).flatMap(ctx -> ReactiveExpressionUtils.evaluate(attribute.getExpression(), ctx)).cast(AuthorizationDecision.class);
    }

    @Override
    public Object handleDeniedInvocation(MethodInvocation methodInvocation, AuthorizationResult authorizationResult) {
        Object attribute = this.registry.getAttribute(methodInvocation);
        PostAuthorizeExpressionAttribute postAuthorizeAttribute = (PostAuthorizeExpressionAttribute)attribute;
        return postAuthorizeAttribute.getHandler().handleDeniedInvocation(methodInvocation, authorizationResult);
    }

    @Override
    public Object handleDeniedInvocationResult(MethodInvocationResult methodInvocationResult, AuthorizationResult authorizationResult) {
        Object attribute = this.registry.getAttribute(methodInvocationResult.getMethodInvocation());
        PostAuthorizeExpressionAttribute postAuthorizeAttribute = (PostAuthorizeExpressionAttribute)attribute;
        return postAuthorizeAttribute.getHandler().handleDeniedInvocationResult(methodInvocationResult, authorizationResult);
    }
}

