/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server.internal;

import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.HTTP2Channel;
import org.eclipse.jetty.http2.HTTP2Connection;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.HTTP2Stream;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.api.server.ServerSessionListener;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PrefaceFrame;
import org.eclipse.jetty.http2.frames.SettingsFrame;
import org.eclipse.jetty.http2.parser.ServerParser;
import org.eclipse.jetty.http2.parser.SettingsBodyParser;
import org.eclipse.jetty.http2.server.internal.HTTP2ServerSession;
import org.eclipse.jetty.http2.server.internal.HttpStreamOverHTTP2;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP2ServerConnection
extends HTTP2Connection
implements ConnectionMetaData,
ServerParser.Listener {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP2ServerConnection.class);
    private final HttpChannel.Factory httpChannelFactory = new HttpChannel.DefaultFactory();
    private final Queue<HttpChannel> httpChannels = new ConcurrentLinkedQueue<HttpChannel>();
    private final Attributes attributes = new Attributes.Lazy();
    private final List<Frame> upgradeFrames = new ArrayList<Frame>();
    private final Connector connector;
    private final ServerSessionListener listener;
    private final HttpConfiguration httpConfig;
    private final String id;
    private final SocketAddress localSocketAddress;
    private final SocketAddress remoteSocketAddress;
    private boolean recycleHttpChannels;

    public HTTP2ServerConnection(Connector connector, EndPoint endPoint, HttpConfiguration httpConfig, HTTP2ServerSession session, ServerSessionListener listener) {
        super(connector.getByteBufferPool(), connector.getExecutor(), endPoint, (HTTP2Session)session, httpConfig.getInputBufferSize(), httpConfig.getMinInputBufferSpace());
        this.connector = connector;
        this.listener = listener;
        this.httpConfig = httpConfig;
        this.id = StringUtil.randomAlphaNumeric((int)16);
        this.localSocketAddress = httpConfig.getLocalAddress() != null ? httpConfig.getLocalAddress() : endPoint.getLocalSocketAddress();
        this.remoteSocketAddress = endPoint.getRemoteSocketAddress();
        this.setRecycleHttpChannels(true);
    }

    public boolean isRecycleHttpChannels() {
        return this.recycleHttpChannels;
    }

    public void setRecycleHttpChannels(boolean recycleHttpChannels) {
        this.recycleHttpChannels = recycleHttpChannels;
    }

    public HTTP2ServerSession getSession() {
        return (HTTP2ServerSession)super.getSession();
    }

    public void onOpen() {
        HTTP2ServerSession session = this.getSession();
        session.notifyLifeCycleOpen();
        this.notifyAccept(session);
        for (Frame frame : this.upgradeFrames) {
            session.onFrame(frame);
        }
        super.onOpen();
        this.produce();
    }

    private void notifyAccept(HTTP2Session session) {
        try {
            this.listener.onAccept((Session)session);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener {}", (Object)this.listener, (Object)x);
        }
    }

    public void onPreface() {
        this.getSession().onPreface();
    }

    public void onNewStream(HTTP2Stream stream, HeadersFrame frame) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing {} on {}", (Object)frame, (Object)stream);
        }
        HttpChannel httpChannel = this.pollHttpChannel();
        HttpStreamOverHTTP2 httpStream = new HttpStreamOverHTTP2(this, httpChannel, stream);
        httpChannel.setHttpStream((HttpStream)httpStream);
        stream.setAttachment((Object)httpStream);
        Runnable task = httpStream.onRequest(frame);
        if (task != null) {
            this.offerTask(task, false);
        }
    }

    public void onDataAvailable(Stream stream, boolean dispatch) {
        Runnable task;
        HTTP2Channel.Server channel;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing data available on {}", (Object)stream);
        }
        if ((channel = (HTTP2Channel.Server)((HTTP2Stream)stream).getAttachment()) != null && (task = channel.onDataAvailable()) != null) {
            this.offerTask(task, dispatch);
        }
    }

    public void onTrailers(Stream stream, HeadersFrame frame) {
        Runnable task;
        HTTP2Channel.Server channel;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing trailers {} on {}", (Object)frame, (Object)stream);
        }
        if ((channel = (HTTP2Channel.Server)((HTTP2Stream)stream).getAttachment()) != null && (task = channel.onTrailer(frame)) != null) {
            this.offerTask(task, false);
        }
    }

    public void onStreamTimeout(Stream stream, TimeoutException timeout, Promise<Boolean> promise) {
        HTTP2Channel.Server channel;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Idle timeout on {}", (Object)stream, (Object)timeout);
        }
        if ((channel = (HTTP2Channel.Server)((HTTP2Stream)stream).getAttachment()) == null) {
            promise.succeeded((Object)false);
            return;
        }
        channel.onTimeout(timeout, (task, timedOut) -> {
            if (task == null) {
                promise.succeeded(timedOut);
                return;
            }
            ThreadPool.executeImmediately((Executor)this.getExecutor(), () -> {
                try {
                    task.run();
                    promise.succeeded(timedOut);
                }
                catch (Throwable x) {
                    promise.failed(x);
                }
            });
        });
    }

    public void onStreamFailure(Stream stream, Throwable failure, Callback callback) {
        HTTP2Stream http2Stream;
        HTTP2Channel.Server channel;
        if (LOG.isDebugEnabled()) {
            LOG.atDebug().setCause(failure).log("Processing stream failure on {}", (Object)stream);
        }
        if ((channel = (HTTP2Channel.Server)(http2Stream = (HTTP2Stream)stream).getAttachment()) == null) {
            HttpChannel httpChannel = this.pollHttpChannel();
            HttpStreamOverHTTP2 httpStream = new HttpStreamOverHTTP2(this, httpChannel, http2Stream);
            httpChannel.setHttpStream((HttpStream)httpStream);
            http2Stream.setAttachment((Object)httpStream);
            channel = httpStream;
        }
        Runnable task = channel.onFailure(failure, callback);
        ThreadPool.executeImmediately((Executor)this.getExecutor(), (Runnable)task);
    }

    public boolean onSessionTimeout(Throwable failure) {
        HTTP2ServerSession session = this.getSession();
        boolean result = session.getStreams().stream().map(stream -> (HTTP2Stream)stream).map(stream -> (HTTP2Channel.Server)stream.getAttachment()).filter(Objects::nonNull).map(HTTP2Channel.Server::isIdle).reduce(true, Boolean::logicalAnd);
        if (LOG.isDebugEnabled()) {
            LOG.atDebug().setCause(failure).log("{} idle timeout on {}", (Object)(result ? "Processed" : "Ignored"), (Object)session);
        }
        return result;
    }

    public void onSessionFailure(Throwable failure, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.atDebug().setCause(failure).log("Processing session failure on {}", (Object)this.getSession());
        }
        callback.succeeded();
    }

    public void push(HTTP2Stream stream, MetaData.Request request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing push {} on {}", (Object)request, (Object)stream);
        }
        HttpChannel httpChannel = this.pollHttpChannel();
        HttpStreamOverHTTP2 httpStream = new HttpStreamOverHTTP2(this, httpChannel, stream);
        httpChannel.setHttpStream((HttpStream)httpStream);
        Runnable task = httpStream.onPushRequest(request);
        if (task != null) {
            this.offerTask(task, true);
        }
    }

    private HttpChannel pollHttpChannel() {
        HttpChannel httpChannel = null;
        if (this.isRecycleHttpChannels()) {
            httpChannel = this.httpChannels.poll();
        }
        if (httpChannel == null) {
            httpChannel = this.httpChannelFactory.newHttpChannel((ConnectionMetaData)this);
        }
        httpChannel.initialize();
        return httpChannel;
    }

    void offerHttpChannel(HttpChannel channel) {
        if (this.isRecycleHttpChannels()) {
            this.httpChannels.offer(channel);
        }
    }

    public boolean upgrade(MetaData.Request request, HttpFields.Mutable responseFields) {
        if (HttpMethod.PRI.is(request.getMethod())) {
            this.getSession().directUpgrade();
        } else {
            SettingsFrame settingsFrame;
            HttpField settingsField = request.getHttpFields().getField(HttpHeader.HTTP2_SETTINGS);
            if (settingsField == null) {
                throw new HttpException.IllegalStateException(400, "Missing " + String.valueOf(HttpHeader.HTTP2_SETTINGS) + " header");
            }
            String value = settingsField.getValue();
            byte[] settings = Base64.getUrlDecoder().decode(value == null ? "" : value);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} {}: {}", new Object[]{this, HttpHeader.HTTP2_SETTINGS, StringUtil.toHexString((byte[])settings)});
            }
            if ((settingsFrame = SettingsBodyParser.parseBody((ByteBuffer)BufferUtil.toBuffer((byte[])settings))) == null) {
                LOG.warn("Invalid {} header value: {}", (Object)HttpHeader.HTTP2_SETTINGS, (Object)value);
                throw new HttpException.IllegalStateException(400);
            }
            responseFields.put(HttpHeader.UPGRADE, "h2c");
            responseFields.put(HttpHeader.CONNECTION, "Upgrade");
            this.getSession().standardUpgrade();
            this.upgradeFrames.add((Frame)new PrefaceFrame());
            this.upgradeFrames.add((Frame)settingsFrame);
            this.upgradeFrames.add((Frame)new HeadersFrame(1, (MetaData)request, null, true));
        }
        return true;
    }

    public String getId() {
        return this.id;
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfig;
    }

    public HttpVersion getHttpVersion() {
        return HttpVersion.HTTP_2;
    }

    public String getProtocol() {
        return this.getHttpVersion().asString();
    }

    public Connection getConnection() {
        return this;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public boolean isPersistent() {
        return true;
    }

    public boolean isPushSupported() {
        return this.getSession().isPushEnabled();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.remoteSocketAddress;
    }

    public SocketAddress getLocalSocketAddress() {
        return this.localSocketAddress;
    }

    public Object getAttribute(String name) {
        return this.attributes.getAttribute(name);
    }

    public Object setAttribute(String name, Object attribute) {
        return this.attributes.setAttribute(name, attribute);
    }

    public Object removeAttribute(String name) {
        return this.attributes.removeAttribute(name);
    }

    public Set<String> getAttributeNameSet() {
        return this.attributes.getAttributeNameSet();
    }

    public void clearAttributes() {
        this.attributes.clearAttributes();
    }
}

