/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.kafka.clients.GroupRebalanceConfig;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerUtils;
import org.apache.kafka.clients.consumer.internals.CoordinatorRequestManager;
import org.apache.kafka.clients.consumer.internals.FetchConfig;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.RequestManagers;
import org.apache.kafka.clients.consumer.internals.ShareConsumeRequestManager;
import org.apache.kafka.clients.consumer.internals.ShareFetchBuffer;
import org.apache.kafka.clients.consumer.internals.ShareFetchMetricsManager;
import org.apache.kafka.clients.consumer.internals.ShareHeartbeatRequestManager;
import org.apache.kafka.clients.consumer.internals.ShareMembershipManager;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEventProcessor;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEvent;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEventHandler;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.common.utils.Utils;
import org.mockito.Mockito;

public class ShareConsumerTestBuilder
implements Closeable {
    static final long DEFAULT_RETRY_BACKOFF_MS = 80L;
    static final long DEFAULT_RETRY_BACKOFF_MAX_MS = 1000L;
    static final int DEFAULT_REQUEST_TIMEOUT_MS = 500;
    static final int DEFAULT_MAX_POLL_INTERVAL_MS = 10000;
    static final String DEFAULT_GROUP_ID = "group-id";
    static final int DEFAULT_HEARTBEAT_INTERVAL_MS = 1000;
    static final double DEFAULT_HEARTBEAT_JITTER_MS = 0.0;
    final LogContext logContext = new LogContext();
    final Time time;
    public final BlockingQueue<ApplicationEvent> applicationEventQueue;
    public final BlockingQueue<BackgroundEvent> backgroundEventQueue;
    final ConsumerConfig config;
    final long retryBackoffMs;
    final SubscriptionState subscriptions;
    final ConsumerMetadata metadata;
    final FetchConfig fetchConfig;
    final Metrics metrics;
    final Timer pollTimer;
    final ShareFetchMetricsManager metricsManager;
    final NetworkClientDelegate networkClientDelegate;
    final Optional<ShareConsumeRequestManager> shareConsumeRequestManager;
    final Optional<CoordinatorRequestManager> coordinatorRequestManager;
    final Optional<ShareHeartbeatRequestManager> heartbeatRequestManager;
    final Optional<ShareMembershipManager> shareMembershipManager;
    final Optional<ShareHeartbeatRequestManager.HeartbeatState> heartbeatState;
    final Optional<ShareHeartbeatRequestManager.HeartbeatRequestState> heartbeatRequestState;
    final RequestManagers requestManagers;
    public final ApplicationEventProcessor applicationEventProcessor;
    public final BackgroundEventHandler backgroundEventHandler;
    final MockClient client;
    final GroupInformation groupInfo;

    public ShareConsumerTestBuilder(GroupInformation groupInfo) {
        this(groupInfo, true);
    }

    public ShareConsumerTestBuilder(GroupInformation groupInfo, boolean enableAutoTick) {
        this.groupInfo = groupInfo;
        this.time = enableAutoTick ? new MockTime(1L) : new MockTime();
        this.applicationEventQueue = new LinkedBlockingQueue<ApplicationEvent>();
        this.backgroundEventQueue = new LinkedBlockingQueue<BackgroundEvent>();
        this.backgroundEventHandler = (BackgroundEventHandler)Mockito.spy((Object)new BackgroundEventHandler(this.backgroundEventQueue));
        Properties properties = new Properties();
        properties.put("key.deserializer", StringDeserializer.class);
        properties.put("value.deserializer", StringDeserializer.class);
        properties.put("request.timeout.ms", (Object)500);
        properties.put("session.timeout.ms", (Object)100);
        properties.put("max.poll.interval.ms", (Object)10000);
        properties.put("heartbeat.interval.ms", (Object)1000);
        properties.put("group.id", groupInfo.groupId);
        properties.put("retry.backoff.ms", (Object)80L);
        properties.put("retry.backoff.max.ms", (Object)1000L);
        properties.put("internal.leave.group.on.close", (Object)true);
        this.config = new ConsumerConfig(properties);
        GroupRebalanceConfig groupRebalanceConfig = new GroupRebalanceConfig((AbstractConfig)this.config, GroupRebalanceConfig.ProtocolType.SHARE);
        this.fetchConfig = new FetchConfig(this.config);
        this.retryBackoffMs = this.config.getLong("retry.backoff.ms");
        this.metrics = ConsumerUtils.createMetrics((ConsumerConfig)this.config, (Time)this.time);
        this.subscriptions = (SubscriptionState)Mockito.spy((Object)ConsumerUtils.createSubscriptionState((ConsumerConfig)this.config, (LogContext)this.logContext));
        this.metadata = (ConsumerMetadata)Mockito.spy((Object)new ConsumerMetadata(this.config, this.subscriptions, this.logContext, new ClusterResourceListeners()));
        this.metricsManager = ConsumerUtils.createShareFetchMetricsManager((Metrics)this.metrics);
        this.pollTimer = this.time.timer((long)groupRebalanceConfig.rebalanceTimeoutMs);
        this.client = new MockClient(this.time, (Metadata)this.metadata);
        MetadataResponse metadataResponse = RequestTestUtils.metadataUpdateWith(1, (Map<String, Integer>)new HashMap<String, Integer>(){
            {
                String topic1 = "test1";
                this.put(topic1, 1);
                String topic2 = "test2";
                this.put(topic2, 1);
            }
        });
        this.client.updateMetadata(metadataResponse);
        this.networkClientDelegate = (NetworkClientDelegate)Mockito.spy((Object)new NetworkClientDelegate(this.time, this.config, this.logContext, (KafkaClient)this.client, (Metadata)this.metadata, this.backgroundEventHandler));
        ShareFetchBuffer fetchBuffer = new ShareFetchBuffer(this.logContext);
        ShareConsumeRequestManager consumeRequestManager = (ShareConsumeRequestManager)Mockito.spy((Object)new ShareConsumeRequestManager(this.time, this.logContext, groupRebalanceConfig.groupId, this.metadata, this.subscriptions, this.fetchConfig, fetchBuffer, this.backgroundEventHandler, this.metricsManager, this.retryBackoffMs, this.retryBackoffMs));
        ShareMembershipManager membershipManager = (ShareMembershipManager)Mockito.spy((Object)new ShareMembershipManager(this.logContext, groupInfo.groupId, null, this.subscriptions, this.metadata, Optional.empty(), this.time, this.metrics));
        CoordinatorRequestManager coordinator = (CoordinatorRequestManager)Mockito.spy((Object)new CoordinatorRequestManager(this.logContext, 80L, 1000L, this.backgroundEventHandler, groupInfo.groupId));
        ShareHeartbeatRequestManager.HeartbeatState heartbeatState = (ShareHeartbeatRequestManager.HeartbeatState)Mockito.spy((Object)new ShareHeartbeatRequestManager.HeartbeatState(this.subscriptions, membershipManager));
        ShareHeartbeatRequestManager.HeartbeatRequestState heartbeatRequestState = (ShareHeartbeatRequestManager.HeartbeatRequestState)Mockito.spy((Object)new ShareHeartbeatRequestManager.HeartbeatRequestState(this.logContext, this.time, (long)groupInfo.heartbeatIntervalMs, this.retryBackoffMs, 1000L, groupInfo.heartbeatJitterMs));
        ShareHeartbeatRequestManager heartbeat = (ShareHeartbeatRequestManager)Mockito.spy((Object)new ShareHeartbeatRequestManager(this.logContext, this.pollTimer, this.config, coordinator, membershipManager, heartbeatState, heartbeatRequestState, this.backgroundEventHandler, this.metrics));
        this.shareConsumeRequestManager = Optional.of(consumeRequestManager);
        this.coordinatorRequestManager = Optional.of(coordinator);
        this.heartbeatRequestManager = Optional.of(heartbeat);
        this.heartbeatState = Optional.of(heartbeatState);
        this.heartbeatRequestState = Optional.of(heartbeatRequestState);
        this.shareMembershipManager = Optional.of(membershipManager);
        this.requestManagers = new RequestManagers(this.logContext, consumeRequestManager, this.coordinatorRequestManager, this.heartbeatRequestManager, this.shareMembershipManager);
        this.applicationEventProcessor = (ApplicationEventProcessor)Mockito.spy((Object)new ApplicationEventProcessor(this.logContext, this.requestManagers, this.metadata, this.subscriptions));
    }

    @Override
    public void close() {
        Utils.closeQuietly((AutoCloseable)this.requestManagers, (String)RequestManagers.class.getSimpleName());
    }

    static GroupInformation createDefaultGroupInformation() {
        return new GroupInformation(DEFAULT_GROUP_ID);
    }

    public static class GroupInformation {
        final String groupId;
        final int heartbeatIntervalMs;
        final double heartbeatJitterMs;

        public GroupInformation(String groupId) {
            this(groupId, 1000, 0.0);
        }

        public GroupInformation(String groupId, int heartbeatIntervalMs, double heartbeatJitterMs) {
            this.heartbeatIntervalMs = heartbeatIntervalMs;
            this.heartbeatJitterMs = heartbeatJitterMs;
            this.groupId = groupId;
        }
    }
}

