/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.widget.dialog;

import java.io.Serializable;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmitter;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IModelComparator;
import org.wicketstuff.jquery.core.ajax.IJQueryAjaxAware;
import org.wicketstuff.jquery.ui.widget.dialog.AbstractDialog;
import org.wicketstuff.jquery.ui.widget.dialog.ButtonAjaxBehavior;
import org.wicketstuff.jquery.ui.widget.dialog.ButtonAjaxPostBehavior;
import org.wicketstuff.jquery.ui.widget.dialog.DialogButton;

public abstract class AbstractFormDialog<T extends Serializable>
extends AbstractDialog<T> {
    private static final long serialVersionUID = 1L;

    public AbstractFormDialog(String id, String title) {
        super(id, title);
    }

    public AbstractFormDialog(String id, IModel<String> title) {
        super(id, title);
    }

    public AbstractFormDialog(String id, String title, IModel<T> model) {
        super(id, title, model, true);
    }

    public AbstractFormDialog(String id, IModel<String> title, IModel<T> model) {
        super(id, title, model, true);
    }

    public AbstractFormDialog(String id, String title, boolean modal) {
        super(id, title, modal);
    }

    public AbstractFormDialog(String id, IModel<String> title, boolean modal) {
        super(id, title, modal);
    }

    public AbstractFormDialog(String id, String title, IModel<T> model, boolean modal) {
        super(id, title, model, modal);
    }

    public AbstractFormDialog(String id, IModel<String> title, IModel<T> model, boolean modal) {
        super(id, title, model, modal);
    }

    public abstract DialogButton getSubmitButton();

    public boolean getDefaultFormProcessing() {
        return true;
    }

    public abstract Form<?> getForm();

    protected Form<?> getForm(DialogButton button) {
        if (button.equals(this.getSubmitButton())) {
            return this.getForm();
        }
        return null;
    }

    public IModelComparator getModelComparator() {
        return IModelComparator.ALWAYS_FALSE;
    }

    @Override
    protected void onInitialize() {
        if (this.getForm() == null) {
            throw new WicketRuntimeException("The form should not be null at this stage");
        }
        super.onInitialize();
    }

    protected void onModelChanged() {
        this.getForm().modelChanged();
    }

    @Override
    void internalOnClick(AjaxRequestTarget target, DialogButton button) {
        Form<?> form = this.getForm(button);
        if (form != null) {
            form.getRootForm().onFormSubmitted((IFormSubmitter)new DialogFormSubmitter(target, button));
            if (!form.hasError()) {
                this.onClick(target, button);
            }
        } else {
            this.onClick(target, button);
        }
    }

    @Override
    public void onClose(IPartialPageRequestHandler handler, DialogButton button) {
    }

    protected abstract void onError(AjaxRequestTarget var1, DialogButton var2);

    protected abstract void onSubmit(AjaxRequestTarget var1, DialogButton var2);

    @Override
    protected ButtonAjaxBehavior newButtonAjaxBehavior(IJQueryAjaxAware source, DialogButton button) {
        return new ButtonAjaxPostBehavior(source, button, this.getForm(button));
    }

    protected class DialogFormSubmitter
    implements IFormSubmitter {
        private final AjaxRequestTarget target;
        private final DialogButton button;

        public DialogFormSubmitter(AjaxRequestTarget target, DialogButton button) {
            this.target = target;
            this.button = button;
        }

        public Form<?> getForm() {
            return AbstractFormDialog.this.getForm();
        }

        public boolean getDefaultFormProcessing() {
            return AbstractFormDialog.this.getDefaultFormProcessing();
        }

        public void onSubmit() {
            AbstractFormDialog.this.onSubmit(this.target, this.button);
        }

        public void onError() {
            AbstractFormDialog.this.onError(this.target, this.button);
        }

        public void onAfterSubmit() {
        }
    }
}

