/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.AccountLockedException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.MultifactorAuthenticationContextValidator;
import org.apereo.cas.authentication.MultifactorAuthenticationFailedException;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderAbsentException;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.authentication.MultifactorAuthenticationRequiredException;
import org.apereo.cas.authentication.PrincipalException;
import org.apereo.cas.authentication.adaptive.UnauthorizedAuthenticationException;
import org.apereo.cas.authentication.exceptions.AccountDisabledException;
import org.apereo.cas.authentication.exceptions.AccountPasswordMustChangeException;
import org.apereo.cas.authentication.exceptions.InvalidLoginLocationException;
import org.apereo.cas.authentication.exceptions.InvalidLoginTimeException;
import org.apereo.cas.authentication.exceptions.UniquePrincipalRequiredException;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.ResponseBuilderLocator;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.util.EncryptionRandomizedSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.core.web.flow.WebflowLoginDecoratorProperties;
import org.apereo.cas.configuration.model.core.web.flow.WebflowProperties;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceForPrincipalException;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.ticket.UnsatisfiedAuthenticationPolicyException;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.cipher.WebflowConversationStateCipherExecutor;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.util.spring.boot.ConditionalOnMissingGraalVMNativeImage;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.CasWebflowCredentialProvider;
import org.apereo.cas.web.flow.ChainingSingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.DefaultSingleSignOnBuildingStrategy;
import org.apereo.cas.web.flow.DefaultSingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.SingleSignOnBuildingStrategy;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategyConfigurer;
import org.apereo.cas.web.flow.actions.AuthenticationExceptionHandlerAction;
import org.apereo.cas.web.flow.actions.CheckWebAuthenticationRequestAction;
import org.apereo.cas.web.flow.actions.ClearWebflowCredentialAction;
import org.apereo.cas.web.flow.actions.InjectResponseHeadersAction;
import org.apereo.cas.web.flow.actions.RedirectToServiceAction;
import org.apereo.cas.web.flow.actions.RenewAuthenticationRequestCheckAction;
import org.apereo.cas.web.flow.actions.WebflowActionBeanSupplier;
import org.apereo.cas.web.flow.actions.storage.PutBrowserStorageAction;
import org.apereo.cas.web.flow.actions.storage.ReadBrowserStorageAction;
import org.apereo.cas.web.flow.actions.storage.WriteBrowserStorageAction;
import org.apereo.cas.web.flow.authentication.CasWebflowExceptionCatalog;
import org.apereo.cas.web.flow.authentication.CasWebflowExceptionConfigurer;
import org.apereo.cas.web.flow.authentication.CasWebflowExceptionHandler;
import org.apereo.cas.web.flow.authentication.DefaultCasWebflowAbstractTicketExceptionHandler;
import org.apereo.cas.web.flow.authentication.DefaultCasWebflowAuthenticationExceptionHandler;
import org.apereo.cas.web.flow.authentication.DefaultCasWebflowCredentialProvider;
import org.apereo.cas.web.flow.authentication.DefaultCasWebflowExceptionCatalog;
import org.apereo.cas.web.flow.authentication.GenericCasWebflowExceptionHandler;
import org.apereo.cas.web.flow.authentication.GroovyCasWebflowAuthenticationExceptionHandler;
import org.apereo.cas.web.flow.authentication.RegisteredServiceAuthenticationPolicySingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.decorator.GroovyLoginWebflowDecorator;
import org.apereo.cas.web.flow.decorator.RestfulLoginWebflowDecorator;
import org.apereo.cas.web.flow.decorator.WebflowDecorator;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.flow.resolver.impl.ServiceTicketRequestWebflowEventResolver;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.Resource;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Webflow})
@Configuration(value="CasCoreWebflowConfiguration", proxyBeanMethods=false)
class CasCoreWebflowConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreWebflowConfiguration.class);

    CasCoreWebflowConfiguration() {
    }

    @Configuration(value="CasCoreWebflowStorageActionsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreWebflowStorageActionsConfiguration {
        CasCoreWebflowStorageActionsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"writeBrowserStorageAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action writeBrowserStorageAction(@Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new WriteBrowserStorageAction(ticketGrantingTicketCookieGenerator)).withId("writeBrowserStorageAction").build().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"readBrowserStorageAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action readBrowserStorageAction(@Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new ReadBrowserStorageAction(ticketGrantingTicketCookieGenerator)).withId("readBrowserStorageAction").build().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"putBrowserStorageAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action putBrowserStorageAction(@Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new PutBrowserStorageAction(ticketGrantingTicketCookieGenerator)).withId("putBrowserStorageAction").build().get();
        }
    }

    @Configuration(value="CasCoreWebflowDecoratorsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreWebflowDecoratorsConfiguration {
        CasCoreWebflowDecoratorsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"groovyLoginWebflowDecorator"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingGraalVMNativeImage
        public WebflowDecorator groovyLoginWebflowDecorator(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (WebflowDecorator)BeanSupplier.of(WebflowDecorator.class).when(BeanCondition.on((String)"cas.webflow.login-decorator.groovy.location").exists().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                WebflowLoginDecoratorProperties decorator = casProperties.getWebflow().getLoginDecorator();
                Resource groovyScript = decorator.getGroovy().getLocation();
                LOGGER.trace("Decorating login webflow using [{}]", (Object)groovyScript);
                return new GroovyLoginWebflowDecorator(groovyScript);
            }).otherwise(WebflowDecorator::noOp).get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"restfulLoginWebflowDecorator"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public WebflowDecorator restfulLoginWebflowDecorator(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (WebflowDecorator)BeanSupplier.of(WebflowDecorator.class).when(BeanCondition.on((String)"cas.webflow.login-decorator.rest.url").isUrl().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                WebflowLoginDecoratorProperties decorator = casProperties.getWebflow().getLoginDecorator();
                LOGGER.trace("Decorating login webflow REST endpoint [{}]", (Object)decorator.getRest().getUrl());
                return new RestfulLoginWebflowDecorator(decorator.getRest());
            }).otherwise(WebflowDecorator::noOp).get();
        }
    }

    @Configuration(value="CasCoreWebflowAuthenticationConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreWebflowAuthenticationConfiguration {
        CasCoreWebflowAuthenticationConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"casWebflowCredentialProvider"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowCredentialProvider casWebflowCredentialProvider(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor) {
            return new DefaultCasWebflowCredentialProvider(tenantExtractor);
        }
    }

    @Configuration(value="CasCoreWebflowSingleSignOnConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreWebflowSingleSignOnConfiguration {
        CasCoreWebflowSingleSignOnConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"singleSignOnParticipationStrategy"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleSignOnParticipationStrategy singleSignOnParticipationStrategy(List<SingleSignOnParticipationStrategyConfigurer> providers) {
            AnnotationAwareOrderComparator.sort(providers);
            ChainingSingleSignOnParticipationStrategy chain = new ChainingSingleSignOnParticipationStrategy();
            providers.forEach(provider -> provider.configureStrategy(chain));
            return chain;
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"singleSignOnBuildingStrategy"})
        public SingleSignOnBuildingStrategy singleSignOnBuildingStrategy(@Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, ConfigurableApplicationContext applicationContext) {
            return new DefaultSingleSignOnBuildingStrategy(ticketRegistrySupport, centralAuthenticationService, applicationContext);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"defaultSingleSignOnParticipationStrategy"})
        public SingleSignOnParticipationStrategy defaultSingleSignOnParticipationStrategy(CasConfigurationProperties casProperties, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new DefaultSingleSignOnParticipationStrategy(servicesManager, casProperties.getSso(), ticketRegistrySupport, authenticationServiceSelectionPlan);
        }

        @Bean
        @ConditionalOnMissingBean(name={"defaultSingleSignOnParticipationStrategyConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleSignOnParticipationStrategyConfigurer defaultSingleSignOnParticipationStrategyConfigurer(@Qualifier(value="defaultSingleSignOnParticipationStrategy") SingleSignOnParticipationStrategy defaultSingleSignOnParticipationStrategy) {
            return chain -> chain.addStrategy(defaultSingleSignOnParticipationStrategy);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"requiredAuthenticationHandlersSingleSignOnParticipationStrategy"})
        public SingleSignOnParticipationStrategy requiredAuthenticationHandlersSingleSignOnParticipationStrategy(ConfigurableApplicationContext applicationContext, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport, @Qualifier(value="authenticationEventExecutionPlan") AuthenticationEventExecutionPlan authenticationEventExecutionPlan) {
            return new RegisteredServiceAuthenticationPolicySingleSignOnParticipationStrategy(servicesManager, ticketRegistrySupport, authenticationServiceSelectionPlan, authenticationEventExecutionPlan, applicationContext);
        }

        @Bean
        @ConditionalOnMissingBean(name={"requiredAuthenticationHandlersSingleSignOnParticipationStrategyConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleSignOnParticipationStrategyConfigurer requiredAuthenticationHandlersSingleSignOnParticipationStrategyConfigurer(@Qualifier(value="requiredAuthenticationHandlersSingleSignOnParticipationStrategy") SingleSignOnParticipationStrategy requiredAuthenticationHandlersSingleSignOnParticipationStrategy) {
            return chain -> chain.addStrategy(requiredAuthenticationHandlersSingleSignOnParticipationStrategy);
        }
    }

    @Configuration(value="CasCoreWebflowExceptionCatalogConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreWebflowExceptionCatalogConfiguration {
        CasCoreWebflowExceptionCatalogConfiguration() {
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"casWebflowExceptionCatalog"})
        public CasWebflowExceptionCatalog casWebflowExceptionCatalog(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            DefaultCasWebflowExceptionCatalog catalog = new DefaultCasWebflowExceptionCatalog();
            catalog.registerException(AccountLockedException.class);
            catalog.registerException(CredentialExpiredException.class);
            catalog.registerException(AccountExpiredException.class);
            catalog.registerException(AccountDisabledException.class);
            catalog.registerException(InvalidLoginLocationException.class);
            catalog.registerException(AccountPasswordMustChangeException.class);
            catalog.registerException(InvalidLoginTimeException.class);
            catalog.registerException(UniquePrincipalRequiredException.class);
            catalog.registerException(AccountNotFoundException.class);
            catalog.registerException(FailedLoginException.class);
            catalog.registerException(UnauthorizedServiceForPrincipalException.class);
            catalog.registerException(PrincipalException.class);
            catalog.registerException(UnsatisfiedAuthenticationPolicyException.class);
            catalog.registerException(UnauthorizedAuthenticationException.class);
            catalog.registerException(MultifactorAuthenticationProviderAbsentException.class);
            catalog.registerException(MultifactorAuthenticationRequiredException.class);
            catalog.registerException(MultifactorAuthenticationFailedException.class);
            catalog.registerExceptions((Collection)casProperties.getAuthn().getErrors().getExceptions());
            List<CasWebflowExceptionConfigurer> configurers = applicationContext.getBeansOfType(CasWebflowExceptionConfigurer.class).values().stream().filter(BeanSupplier::isNotProxy).collect(Collectors.toList());
            AnnotationAwareOrderComparator.sort(configurers);
            configurers.forEach(cfg -> cfg.configure((CasWebflowExceptionCatalog)catalog));
            return catalog;
        }
    }

    @Configuration(value="CasCoreWebflowExceptionHandlingConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreWebflowExceptionHandlingConfiguration {
        CasCoreWebflowExceptionHandlingConfiguration() {
        }

        @ConditionalOnMissingBean(name={"groovyCasWebflowAuthenticationExceptionHandler"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingGraalVMNativeImage
        public CasWebflowExceptionHandler<Exception> groovyCasWebflowAuthenticationExceptionHandler(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) throws Exception {
            return (CasWebflowExceptionHandler)BeanSupplier.of(CasWebflowExceptionHandler.class).when(BeanCondition.on((String)"cas.authn.errors.groovy.location").exists().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new GroovyCasWebflowAuthenticationExceptionHandler(casProperties.getAuthn().getErrors().getGroovy().getLocation(), (ApplicationContext)applicationContext)).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"defaultCasWebflowAuthenticationExceptionHandler"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowExceptionHandler<AuthenticationException> defaultCasWebflowAuthenticationExceptionHandler(@Qualifier(value="casWebflowExceptionCatalog") CasWebflowExceptionCatalog handledAuthenticationExceptions) {
            return new DefaultCasWebflowAuthenticationExceptionHandler(handledAuthenticationExceptions);
        }

        @ConditionalOnMissingBean(name={"defaultCasWebflowAbstractTicketExceptionHandler"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowExceptionHandler<AbstractTicketException> defaultCasWebflowAbstractTicketExceptionHandler(@Qualifier(value="casWebflowExceptionCatalog") CasWebflowExceptionCatalog handledAuthenticationExceptions) {
            return new DefaultCasWebflowAbstractTicketExceptionHandler(handledAuthenticationExceptions);
        }

        @ConditionalOnMissingBean(name={"genericCasWebflowExceptionHandler"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowExceptionHandler genericCasWebflowExceptionHandler(@Qualifier(value="casWebflowExceptionCatalog") CasWebflowExceptionCatalog handledAuthenticationExceptions) {
            return new GenericCasWebflowExceptionHandler(handledAuthenticationExceptions);
        }
    }

    @Configuration(value="CasCoreWebflowActionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreWebflowActionConfiguration {
        CasCoreWebflowActionConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"clearWebflowCredentialsAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action clearWebflowCredentialsAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(ClearWebflowCredentialAction::new).withId("clearWebflowCredentialsAction").build().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"checkWebAuthenticationRequestAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action checkWebAuthenticationRequestAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new CheckWebAuthenticationRequestAction(casProperties.getAuthn().getMfa().getCore().getContentType())).withId("checkWebAuthenticationRequestAction").build().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"renewAuthenticationRequestCheckAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action renewAuthenticationRequestCheckAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="singleSignOnParticipationStrategy") SingleSignOnParticipationStrategy singleSignOnParticipationStrategy) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new RenewAuthenticationRequestCheckAction(singleSignOnParticipationStrategy)).withId("renewAuthenticationRequestCheckAction").build().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"redirectToServiceAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action redirectToServiceAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="webApplicationResponseBuilderLocator") ResponseBuilderLocator responseBuilderLocator) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new RedirectToServiceAction(responseBuilderLocator)).withId("redirectToServiceAction").build().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"injectResponseHeadersAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action injectResponseHeadersAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="webApplicationResponseBuilderLocator") ResponseBuilderLocator responseBuilderLocator) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new InjectResponseHeadersAction(responseBuilderLocator)).withId("injectResponseHeadersAction").build().get();
        }

        @ConditionalOnMissingBean(name={"authenticationExceptionHandler"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action authenticationExceptionHandler(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, List<CasWebflowExceptionHandler> handlers) {
            AnnotationAwareOrderComparator.sort(handlers);
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new AuthenticationExceptionHandlerAction(handlers)).withId("authenticationExceptionHandler").build().get();
        }
    }

    @Configuration(value="CasCoreWebflowContextConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreWebflowContextConfiguration {
        CasCoreWebflowContextConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"casWebflowConfigurationContext"})
        public CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="principalFactory") PrincipalFactory principalFactory, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="authenticationContextValidator") MultifactorAuthenticationContextValidator authenticationContextValidator, @Qualifier(value="authenticationEventExecutionPlan") AuthenticationEventExecutionPlan authenticationEventExecutionPlan, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="warnCookieGenerator") CasCookieBuilder warnCookieGenerator, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="singleSignOnParticipationStrategy") SingleSignOnParticipationStrategy webflowSingleSignOnParticipationStrategy, @Qualifier(value="singleSignOnBuildingStrategy") SingleSignOnBuildingStrategy singleSignOnBuildingStrategy, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, @Qualifier(value="casWebflowExceptionCatalog") CasWebflowExceptionCatalog casWebflowExceptionCatalog, @Qualifier(value="casWebflowCredentialProvider") CasWebflowCredentialProvider casWebflowCredentialProvider, @Qualifier(value="multifactorAuthenticationProviderSelector") MultifactorAuthenticationProviderSelector multifactorAuthenticationProviderSelector) {
            return CasWebflowEventResolutionConfigurationContext.builder().casWebflowCredentialProvider(casWebflowCredentialProvider).authenticationContextValidator(authenticationContextValidator).authenticationSystemSupport(authenticationSystemSupport).argumentExtractors(CollectionUtils.wrap((Object)argumentExtractor)).centralAuthenticationService(centralAuthenticationService).servicesManager(servicesManager).ticketRegistrySupport(ticketRegistrySupport).warnCookieGenerator(warnCookieGenerator).authenticationRequestServiceSelectionStrategies(authenticationServiceSelectionPlan).registeredServiceAccessStrategyEnforcer(registeredServiceAccessStrategyEnforcer).casProperties(casProperties).ticketRegistry(ticketRegistry).singleSignOnParticipationStrategy(webflowSingleSignOnParticipationStrategy).singleSignOnBuildingStrategy(singleSignOnBuildingStrategy).applicationContext(applicationContext).ticketGrantingTicketCookieGenerator(ticketGrantingTicketCookieGenerator).authenticationEventExecutionPlan(authenticationEventExecutionPlan).principalFactory(principalFactory).multifactorAuthenticationProviderSelector(multifactorAuthenticationProviderSelector).casWebflowExceptionCatalog(casWebflowExceptionCatalog).tenantExtractor(tenantExtractor).build();
        }
    }

    @Configuration(value="CasCoreWebflowEventResolutionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreWebflowEventResolutionConfiguration {
        CasCoreWebflowEventResolutionConfiguration() {
        }

        @ConditionalOnMissingBean(name={"serviceTicketRequestWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver serviceTicketRequestWebflowEventResolver(@Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return new ServiceTicketRequestWebflowEventResolver(casWebflowConfigurationContext);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"webflowCipherExecutor"})
        public CipherExecutor webflowCipherExecutor(CasConfigurationProperties casProperties) {
            WebflowProperties webflow = casProperties.getWebflow();
            EncryptionRandomizedSigningJwtCryptographyProperties crypto = webflow.getCrypto();
            boolean enabled = crypto.isEnabled();
            if (!enabled && StringUtils.isNotBlank((CharSequence)crypto.getEncryption().getKey()) && StringUtils.isNotBlank((CharSequence)crypto.getSigning().getKey())) {
                LOGGER.warn("Webflow encryption/signing is not enabled explicitly in the configuration, yet signing/encryption keys are defined for operations. CAS will proceed to enable the webflow encryption/signing functionality.");
                enabled = true;
            }
            if (enabled) {
                return WebflowConversationStateCipherExecutor.from((EncryptionRandomizedSigningJwtCryptographyProperties)crypto);
            }
            LOGGER.warn("Webflow encryption/signing is turned off. This MAY NOT be safe in a production environment. Consider using other choices to handle encryption, signing and verification of webflow state.");
            return CipherExecutor.noOp();
        }
    }
}

