/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.servlet.Filter;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.audit.AuditEngineProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.monitor.JdbcSecurityActuatorEndpointsMonitorProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.crypto.DefaultPasswordEncoder;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.CasWebSecurityConfigurer;
import org.apereo.cas.web.security.CasWebSecurityConfigurerAdapter;
import org.apereo.cas.web.security.CasWebflowSecurityContextRepository;
import org.apereo.inspektr.common.web.ClientInfoExtractionOptions;
import org.apereo.inspektr.common.web.ClientInfoThreadLocalFilter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.actuate.endpoint.web.PathMappedEndpoints;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.io.Resource;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.argon2.Argon2PasswordEncoder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.DelegatingPasswordEncoder;
import org.springframework.security.crypto.password.NoOpPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;
import org.springframework.security.crypto.scrypt.SCryptPasswordEncoder;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.provisioning.JdbcUserDetailsManager;
import org.springframework.security.provisioning.UserDetailsManager;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.context.DelegatingSecurityContextRepository;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.RequestAttributeSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextHolderFilter;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.webflow.context.servlet.FlowUrlHandler;
import org.springframework.webflow.executor.FlowExecutor;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.WebApplication})
@Configuration(value="CasWebSecurityConfiguration", proxyBeanMethods=false)
@EnableMethodSecurity(prePostEnabled=true, securedEnabled=true, jsr250Enabled=true)
@EnableWebSecurity
class CasWebSecurityConfiguration {
    CasWebSecurityConfiguration() {
    }

    @Bean
    @Lazy(value=false)
    public InitializingBean securityContextHolderInitialization() {
        return () -> SecurityContextHolder.setStrategyName((String)"MODE_THREADLOCAL");
    }

    @Configuration(value="CasWebAppSecurityJsonUsersConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnProperty(name={"cas.monitor.endpoints.json.location"})
    static class CasWebAppSecurityJsonUsersConfiguration {
        private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
        private static final Pattern PATTERN_PASSWORD_ALG = Pattern.compile("^\\{.+\\}.*");

        CasWebAppSecurityJsonUsersConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"jsonUserDetailsService"})
        public UserDetailsService userDetailsService(CasConfigurationProperties casProperties) throws Exception {
            Resource resource = casProperties.getMonitor().getEndpoints().getJson().getLocation();
            try (InputStream in = resource.getInputStream();){
                List listOfUsers = (List)MAPPER.readValue(in, (TypeReference)new TypeReference<List<CasUserDetails>>(this){});
                List<UserDetails> userDetails = listOfUsers.stream().map(user -> {
                    List<SimpleGrantedAuthority> authorities = user.getAuthorities().stream().map(authority -> Strings.CI.prependIfMissing(authority, (CharSequence)"ROLE_", new CharSequence[0])).map(SimpleGrantedAuthority::new).toList();
                    Object password = user.getPassword();
                    if (!PATTERN_PASSWORD_ALG.matcher((CharSequence)password).matches()) {
                        password = "{noop}" + (String)password;
                    }
                    return User.builder().username(user.getUsername()).password((String)password).authorities(authorities).build();
                }).toList();
                InMemoryUserDetailsManager inMemoryUserDetailsManager = new InMemoryUserDetailsManager(userDetails);
                return inMemoryUserDetailsManager;
            }
        }

        @Bean
        @ConditionalOnMissingBean(name={"jsonUserDetailsPasswordEncoder"})
        public PasswordEncoder jsonUserDetailsPasswordEncoder() {
            HashMap<String, Object> encoders = new HashMap<String, Object>();
            encoders.put("pbkdf2", Pbkdf2PasswordEncoder.defaultsForSpringSecurity_v5_8());
            encoders.put("scrypt", SCryptPasswordEncoder.defaultsForSpringSecurity_v5_8());
            encoders.put("argon2", Argon2PasswordEncoder.defaultsForSpringSecurity_v5_8());
            encoders.put("bcrypt", new BCryptPasswordEncoder());
            encoders.put("sha256", new DefaultPasswordEncoder("SHA-256", StandardCharsets.UTF_8.name()));
            encoders.put("sha512", new DefaultPasswordEncoder("SHA-512", StandardCharsets.UTF_8.name()));
            encoders.put("noop", NoOpPasswordEncoder.getInstance());
            return new DelegatingPasswordEncoder("sha512", encoders);
        }

        private static final class CasUserDetails
        implements Serializable {
            private static final long serialVersionUID = -741527534790033702L;
            private String username;
            private String password;
            private List<String> authorities = new ArrayList<String>();

            @Generated
            public String getUsername() {
                return this.username;
            }

            @Generated
            public String getPassword() {
                return this.password;
            }

            @Generated
            public List<String> getAuthorities() {
                return this.authorities;
            }

            @Generated
            public void setUsername(String username) {
                this.username = username;
            }

            @Generated
            public void setPassword(String password) {
                this.password = password;
            }

            @Generated
            public void setAuthorities(List<String> authorities) {
                this.authorities = authorities;
            }

            @Generated
            public CasUserDetails() {
            }
        }
    }

    @Configuration(value="CasWebAppSecurityJdbcConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnProperty(name={"cas.monitor.endpoints.jdbc.query"})
    static class CasWebAppSecurityJdbcConfiguration {
        CasWebAppSecurityJdbcConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"jdbcUserDetailsPasswordEncoder"})
        public static PasswordEncoder jdbcUserDetailsPasswordEncoder(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            JdbcSecurityActuatorEndpointsMonitorProperties jdbc = casProperties.getMonitor().getEndpoints().getJdbc();
            return PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)jdbc.getPasswordEncoder(), (ApplicationContext)applicationContext);
        }

        @Bean
        @ConditionalOnMissingBean(name={"jdbcUserDetailsManager"})
        public UserDetailsManager jdbcUserDetailsManager(CasConfigurationProperties casProperties) {
            JdbcSecurityActuatorEndpointsMonitorProperties jdbc = casProperties.getMonitor().getEndpoints().getJdbc();
            JdbcUserDetailsManager manager = new JdbcUserDetailsManager((DataSource)JpaBeans.newDataSource((AbstractJpaProperties)jdbc));
            manager.setRolePrefix(jdbc.getRolePrefix());
            manager.setUsersByUsernameQuery(jdbc.getQuery());
            return manager;
        }
    }

    @Configuration(value="CasWebappCoreSecurityConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasWebappCoreSecurityConfiguration {
        CasWebappCoreSecurityConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"securityContextRepository"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SecurityContextRepository securityContextRepository(ConfigurableApplicationContext applicationContext, @Qualifier(value="loginFlowUrlHandler") FlowUrlHandler loginFlowUrlHandler, @Qualifier(value="loginFlowExecutor") FlowExecutor loginFlowExecutor) {
            return new DelegatingSecurityContextRepository(new SecurityContextRepository[]{new RequestAttributeSecurityContextRepository(), new HttpSessionSecurityContextRepository(), new CasWebflowSecurityContextRepository(applicationContext)});
        }

        @Bean
        @ConditionalOnMissingBean(name={"casClientInfoLoggingFilter"})
        public FilterRegistrationBean<ClientInfoThreadLocalFilter> casClientInfoLoggingFilter(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, CasConfigurationProperties casProperties) {
            FilterRegistrationBean bean = new FilterRegistrationBean();
            AuditEngineProperties audit = casProperties.getAudit().getEngine();
            ClientInfoExtractionOptions options = ClientInfoExtractionOptions.builder().alternateLocalAddrHeaderName(audit.getAlternateClientAddrHeaderName()).alternateServerAddrHeaderName(audit.getAlternateServerAddrHeaderName()).useServerHostAddress(audit.isUseServerHostAddress()).httpRequestHeaders(audit.getHttpRequestHeaders()).build();
            bean.setFilter((Filter)new ClientInfoThreadLocalFilter(options, tenantExtractor));
            bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
            bean.setName("CAS Client Info Logging Filter");
            bean.setAsyncSupported(true);
            bean.setOrder(-2147483647);
            return bean;
        }

        @Bean
        public FilterRegistrationBean<SecurityContextHolderFilter> securityContextHolderFilter(@Qualifier(value="securityContextRepository") SecurityContextRepository securityContextRepository) {
            FilterRegistrationBean bean = new FilterRegistrationBean();
            bean.setFilter((Filter)new SecurityContextHolderFilter(securityContextRepository));
            bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
            bean.setName("Spring Security Context Holder Filter");
            bean.setAsyncSupported(true);
            bean.setOrder(-2147483647);
            return bean;
        }

        @Bean
        @ConditionalOnMissingBean(name={"casWebSecurityCustomizer"})
        public WebSecurityCustomizer casWebSecurityCustomizer(@Qualifier(value="securityContextRepository") SecurityContextRepository securityContextRepository, ObjectProvider<PathMappedEndpoints> pathMappedEndpoints, List<CasWebSecurityConfigurer> configurersList, WebEndpointProperties webEndpointProperties, ManagementServerProperties managementServerProperties, CasConfigurationProperties casProperties, WebProperties webProperties) {
            CasWebSecurityConfigurerAdapter adapter = new CasWebSecurityConfigurerAdapter(casProperties, webEndpointProperties, managementServerProperties, pathMappedEndpoints, configurersList, securityContextRepository, webProperties);
            return adapter::configureWebSecurity;
        }

        @Bean
        @ConditionalOnMissingBean(name={"casWebSecurityConfigurerAdapter"})
        public SecurityFilterChain casWebSecurityConfigurerAdapter(ConfigurableApplicationContext applicationContext, @Qualifier(value="securityContextRepository") SecurityContextRepository securityContextRepository, HttpSecurity http, ObjectProvider<PathMappedEndpoints> pathMappedEndpoints, List<CasWebSecurityConfigurer> configurersList, WebEndpointProperties webEndpointProperties, ManagementServerProperties managementServerProperties, SecurityProperties securityProperties, CasConfigurationProperties casProperties, WebProperties webProperties) throws Exception {
            CasWebSecurityConfigurerAdapter adapter = new CasWebSecurityConfigurerAdapter(casProperties, webEndpointProperties, managementServerProperties, pathMappedEndpoints, configurersList, securityContextRepository, webProperties);
            return (SecurityFilterChain)adapter.configureHttpSecurity(http, (ApplicationContext)applicationContext).build();
        }
    }

    @Configuration(value="CasWebAppSecurityMvcConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasWebAppSecurityMvcConfiguration {
        CasWebAppSecurityMvcConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"casWebAppSecurityWebMvcConfigurer"})
        public WebMvcConfigurer casWebAppSecurityWebMvcConfigurer(final CasConfigurationProperties casProperties) {
            return new WebMvcConfigurer(){

                public void addViewControllers(@Nonnull ViewControllerRegistry registry) {
                    if (casProperties.getMonitor().getEndpoints().isFormLoginEnabled()) {
                        registry.addViewController("/adminlogin").setViewName("admin/casAdminLoginView");
                        registry.setOrder(Integer.MIN_VALUE);
                    }
                }
            };
        }
    }
}

