/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.events;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apereo.cas.support.events.CasEventAggregate;
import org.apereo.cas.support.events.CasEventRepositoryFilter;
import org.apereo.cas.support.events.dao.CasEvent;

@FunctionalInterface
public interface CasEventRepository {
    public static final String PARAM_SOURCE = "source";
    public static final String TRANSACTION_MANAGER_EVENTS = "transactionManagerEvents";
    public static final String BEAN_NAME = "casEventRepository";

    default public CasEventRepositoryFilter getEventRepositoryFilter() {
        return CasEventRepositoryFilter.noOp();
    }

    default public void removeAll() {
    }

    default public <T> void withTransaction(Consumer<T> action) {
        action.accept(null);
    }

    public CasEvent save(CasEvent var1) throws Throwable;

    default public Stream<? extends CasEvent> load() {
        return Stream.empty();
    }

    default public Stream<? extends CasEvent> load(ZonedDateTime dateTime) {
        return Stream.empty();
    }

    default public Stream<? extends CasEvent> getEventsOfTypeForPrincipal(String type, String principal) {
        return Stream.empty();
    }

    default public Stream<? extends CasEvent> getEventsOfTypeForPrincipal(String type, String principal, ZonedDateTime dateTime) {
        return Stream.empty();
    }

    default public Stream<? extends CasEvent> getEventsOfType(String type) {
        return Stream.empty();
    }

    default public Stream<? extends CasEvent> getEventsOfType(String type, ZonedDateTime dateTime) {
        return Stream.empty();
    }

    default public Stream<? extends CasEvent> getEventsForPrincipal(String id) {
        return Stream.empty();
    }

    default public Stream<? extends CasEvent> getEventsForPrincipal(String id, ZonedDateTime dateTime) {
        return Stream.empty();
    }

    default public Stream<CasEventAggregate> aggregate() {
        return this.aggregate(Duration.ofDays(1L));
    }

    default public Stream<CasEventAggregate> aggregate(Duration start) {
        return this.aggregate(null, start);
    }

    default public Stream<CasEventAggregate> aggregate(Class type, Duration start) {
        return Stream.empty();
    }

    public static CasEventRepository noOp() {
        return event -> event;
    }
}

