/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.authenticator;

import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.principal.NullPrincipal;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceUsernameProviderContext;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20ClientAuthenticationMethods;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.authenticator.OAuth20ClientIdClientSecretCredential;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.OAuth20ClientSecretValidator;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessTokenFactory;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.function.FunctionUtils;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.CredentialSource;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class OAuth20ClientIdClientSecretAuthenticator
implements Authenticator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20ClientIdClientSecretAuthenticator.class);
    private final ServicesManager servicesManager;
    private final ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory;
    private final AuditableExecution registeredServiceAccessStrategyEnforcer;
    private final TicketRegistry ticketRegistry;
    private final PrincipalResolver principalResolver;
    private final OAuth20RequestParameterResolver requestParameterResolver;
    private final OAuth20ClientSecretValidator clientSecretValidator;
    private final OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter;
    private final TicketFactory ticketFactory;
    private final ConfigurableApplicationContext applicationContext;

    public Optional<Credentials> validate(CallContext callContext, Credentials credentials) {
        return (Optional)FunctionUtils.doUnchecked(() -> {
            OAuth20ClientAuthenticationMethods requiredAuthnMethod;
            boolean proceed;
            LOGGER.debug("Authenticating credential [{}]", (Object)credentials);
            UsernamePasswordCredentials upc = (UsernamePasswordCredentials)credentials;
            String id = upc.getUsername();
            OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.servicesManager, id);
            AuditableContext audit = AuditableContext.builder().registeredService((RegisteredService)registeredService).build();
            AuditableExecutionResult accessResult = this.registeredServiceAccessStrategyEnforcer.execute(audit);
            boolean bl = proceed = !accessResult.isExecutionFailure() && this.canAuthenticate(callContext);
            if (!proceed) {
                String name = this.getClass().getSimpleName();
                LOGGER.debug("Skipping authenticator [{}]; service access is rejected for [{}] or the authentication request is not supported", (Object)name, (Object)registeredService);
                return Optional.empty();
            }
            OAuth20ClientAuthenticationMethods oAuth20ClientAuthenticationMethods = requiredAuthnMethod = CredentialSource.FORM.name().equalsIgnoreCase(upc.getSource()) ? OAuth20ClientAuthenticationMethods.CLIENT_SECRET_POST : OAuth20ClientAuthenticationMethods.CLIENT_SECRET_BASIC;
            if (!this.isAuthenticationMethodSupported(callContext, registeredService, requiredAuthnMethod)) {
                LOGGER.warn("Client authentication method [{}] is not supported for service [{}]", (Object)requiredAuthnMethod, (Object)registeredService.getName());
                return Optional.empty();
            }
            this.validateCredentials(upc, registeredService, callContext);
            OAuth20ClientIdClientSecretCredential credential = new OAuth20ClientIdClientSecretCredential(upc.getUsername(), upc.getPassword());
            Principal resolvedPrincipal = this.principalResolver.resolve((Credential)credential);
            WebApplicationService service = (WebApplicationService)this.webApplicationServiceServiceFactory.createService(registeredService.getServiceId());
            CommonProfile profile = new CommonProfile();
            if (resolvedPrincipal instanceof NullPrincipal) {
                LOGGER.debug("No principal was resolved. Falling back to the username [{}] from the credentials.", (Object)id);
                profile.setId(id);
            } else {
                RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService((RegisteredService)registeredService).service((Service)service).principal(resolvedPrincipal).applicationContext((ApplicationContext)this.applicationContext).build();
                String username = registeredService.getUsernameAttributeProvider().resolveUsername(usernameContext);
                profile.setId(username);
            }
            profile.addAttribute("client_id", (Object)id);
            LOGGER.debug("Created profile id [{}]", (Object)profile.getId());
            Principal principal = this.buildAuthenticatedPrincipal(resolvedPrincipal, registeredService, service, callContext);
            profile.addAttributes(principal.getAttributes());
            LOGGER.debug("Authenticated user profile [{}]", (Object)profile);
            credentials.setUserProfile((UserProfile)profile);
            return Optional.of(credentials);
        });
    }

    protected boolean isAuthenticationMethodSupported(CallContext callContext, OAuthRegisteredService registeredService, OAuth20ClientAuthenticationMethods requiredAuthnMethod) {
        return OAuth20Utils.isTokenAuthenticationMethodSupportedFor(callContext, registeredService, requiredAuthnMethod);
    }

    protected Principal buildAuthenticatedPrincipal(Principal resolvedPrincipal, OAuthRegisteredService registeredService, WebApplicationService service, CallContext callContext) throws Throwable {
        OAuth20AccessTokenFactory accessTokenFactory = (OAuth20AccessTokenFactory)this.ticketFactory.get(OAuth20AccessToken.class);
        Collection scopes = this.requestParameterResolver.resolveRequestedScopes(callContext.webContext());
        OAuth20ResponseTypes responseType = this.requestParameterResolver.resolveResponseType(callContext.webContext());
        OAuth20GrantTypes grantType = this.requestParameterResolver.resolveGrantType(callContext.webContext());
        this.requestParameterResolver.resolveRequestParameter(callContext.webContext(), "code").ifPresent(code -> FunctionUtils.doAndHandle(__ -> {
            OAuth20Token oauthCode = (OAuth20Token)this.ticketRegistry.getTicket(code, OAuth20Token.class);
            if (oauthCode != null && !oauthCode.isExpired()) {
                LOGGER.debug("Found OAuth code [{}] in the ticket registry", code);
                scopes.addAll(oauthCode.getScopes());
            }
        }));
        Authentication authentication = DefaultAuthenticationBuilder.newInstance((Principal)resolvedPrincipal).build();
        OAuth20AccessToken accessToken = accessTokenFactory.create((Service)service, authentication, scopes, registeredService.getClientId(), responseType, grantType);
        LOGGER.debug("Created access token [{}] for service [{}] based on scopes [{}]", new Object[]{accessToken.getId(), service.getId(), scopes});
        Principal finalPrincipal = this.profileScopeToAttributesFilter.filter((Service)service, resolvedPrincipal, (RegisteredService)registeredService, accessToken);
        LOGGER.debug("Built final principal [{}]", (Object)finalPrincipal);
        return finalPrincipal;
    }

    protected void validateCredentials(UsernamePasswordCredentials credentials, OAuthRegisteredService registeredService, CallContext callContext) {
        if (!this.clientSecretValidator.validate(registeredService, credentials.getPassword())) {
            throw new CredentialsException("Invalid client credentials provided for registered service: " + registeredService.getName());
        }
    }

    protected boolean canAuthenticate(CallContext callContext) {
        WebContext context = callContext.webContext();
        OAuth20GrantTypes grantType = this.requestParameterResolver.resolveGrantType(context);
        if (grantType == OAuth20GrantTypes.PASSWORD) {
            LOGGER.debug("Skipping client credential authentication to use password authentication");
            return false;
        }
        Pair clientIdAndSecret = this.requestParameterResolver.resolveClientIdAndClientSecret(callContext);
        if (grantType == OAuth20GrantTypes.REFRESH_TOKEN && StringUtils.isNotBlank((CharSequence)((CharSequence)clientIdAndSecret.getKey())) && StringUtils.isBlank((CharSequence)((CharSequence)clientIdAndSecret.getValue()))) {
            LOGGER.debug("Skipping client credential authentication to use refresh token authentication");
            return false;
        }
        Optional code = context.getRequestParameter("code");
        if (code.isPresent()) {
            LOGGER.debug("Checking if the OAuth code issued contains code challenge");
            OAuth20Code token = (OAuth20Code)FunctionUtils.doAndHandle(() -> {
                OAuth20Code state = (OAuth20Code)this.ticketRegistry.getTicket((String)code.get(), OAuth20Code.class);
                return state == null || state.isExpired() ? null : state;
            });
            if (token != null && StringUtils.isNotEmpty((CharSequence)token.getCodeChallenge())) {
                LOGGER.debug("The OAuth code [{}] issued contains code challenge which requires PKCE Authentication", code.get());
                return false;
            }
        }
        return true;
    }

    @Generated
    public OAuth20ClientIdClientSecretAuthenticator(ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, AuditableExecution registeredServiceAccessStrategyEnforcer, TicketRegistry ticketRegistry, PrincipalResolver principalResolver, OAuth20RequestParameterResolver requestParameterResolver, OAuth20ClientSecretValidator clientSecretValidator, OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter, TicketFactory ticketFactory, ConfigurableApplicationContext applicationContext) {
        this.servicesManager = servicesManager;
        this.webApplicationServiceServiceFactory = webApplicationServiceServiceFactory;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
        this.ticketRegistry = ticketRegistry;
        this.principalResolver = principalResolver;
        this.requestParameterResolver = requestParameterResolver;
        this.clientSecretValidator = clientSecretValidator;
        this.profileScopeToAttributesFilter = profileScopeToAttributesFilter;
        this.ticketFactory = ticketFactory;
        this.applicationContext = applicationContext;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public ServiceFactory<WebApplicationService> getWebApplicationServiceServiceFactory() {
        return this.webApplicationServiceServiceFactory;
    }

    @Generated
    public AuditableExecution getRegisteredServiceAccessStrategyEnforcer() {
        return this.registeredServiceAccessStrategyEnforcer;
    }

    @Generated
    public TicketRegistry getTicketRegistry() {
        return this.ticketRegistry;
    }

    @Generated
    public PrincipalResolver getPrincipalResolver() {
        return this.principalResolver;
    }

    @Generated
    public OAuth20RequestParameterResolver getRequestParameterResolver() {
        return this.requestParameterResolver;
    }

    @Generated
    public OAuth20ClientSecretValidator getClientSecretValidator() {
        return this.clientSecretValidator;
    }

    @Generated
    public OAuth20ProfileScopeToAttributesFilter getProfileScopeToAttributesFilter() {
        return this.profileScopeToAttributesFilter;
    }

    @Generated
    public TicketFactory getTicketFactory() {
        return this.ticketFactory;
    }

    @Generated
    public ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

