/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.BaseOAuth20Controller;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.FrameworkParameters;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.engine.DefaultCallbackLogic;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.exception.http.WithLocationAction;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.context.JEEFrameworkParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.ModelAndView;

@Tag(name="OAuth")
public class OAuth20CallbackAuthorizeEndpointController
extends BaseOAuth20Controller<OAuth20ConfigurationContext> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20CallbackAuthorizeEndpointController.class);

    public OAuth20CallbackAuthorizeEndpointController(OAuth20ConfigurationContext oAuthConfigurationContext) {
        super(oAuthConfigurationContext);
    }

    @GetMapping(path={"/oauth2.0/callbackAuthorize"})
    @Operation(summary="Handle OAuth callback authorize request", hidden=true)
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) {
        ServicesManager servicesManager;
        OAuthRegisteredService serviceClient;
        this.ensureSessionReplicationIsAutoconfiguredIfNeedBe(request);
        OAuth20CallbackLogic callback = new OAuth20CallbackLogic();
        JEEContext context = new JEEContext(request, response);
        String defaultUrl = null;
        Optional clientId = context.getRequestParameter("client_id");
        Optional redirectUri = context.getRequestParameter("redirect_uri");
        if (clientId.isPresent() && redirectUri.isPresent() && (serviceClient = OAuth20Utils.getRegisteredOAuthServiceByClientId(servicesManager = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getServicesManager(), (String)clientId.get())) != null && serviceClient.matches((String)redirectUri.get())) {
            defaultUrl = (String)redirectUri.get();
        }
        callback.perform(((OAuth20ConfigurationContext)this.getConfigurationContext()).getOauthConfig(), defaultUrl, Boolean.FALSE, "CasOAuthClient", (FrameworkParameters)new JEEFrameworkParameters(request, response));
        String url = callback.getRedirectUrl();
        ProfileManager manager = new ProfileManager((WebContext)context, ((OAuth20ConfigurationContext)this.getConfigurationContext()).getSessionStore());
        LOGGER.trace("OAuth callback URL is [{}]", (Object)url);
        return ((OAuth20ConfigurationContext)this.getConfigurationContext()).getCallbackAuthorizeViewResolver().resolve((WebContext)context, manager, url);
    }

    private static final class OAuth20CallbackLogic
    extends DefaultCallbackLogic {
        private String redirectUrl;

        private OAuth20CallbackLogic() {
        }

        protected HttpAction redirectToOriginallyRequestedUrl(CallContext callContext, String defaultUrl) {
            HttpAction result = this.getSavedRequestHandler().restore(callContext, defaultUrl);
            if (result instanceof WithLocationAction) {
                WithLocationAction locationAction = (WithLocationAction)result;
                this.redirectUrl = locationAction.getLocation();
            }
            return result;
        }

        @Generated
        public String getRedirectUrl() {
            return this.redirectUrl;
        }
    }
}

