/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.ext;

import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.BaseAccessTokenGrantRequestExtractor;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.ticket.OAuth20UnauthorizedScopeRequestException;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public class AccessTokenAuthorizationCodeGrantRequestExtractor
extends BaseAccessTokenGrantRequestExtractor<OAuth20ConfigurationContext> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessTokenAuthorizationCodeGrantRequestExtractor.class);

    public AccessTokenAuthorizationCodeGrantRequestExtractor(ObjectProvider<OAuth20ConfigurationContext> config) {
        super(config);
    }

    protected static boolean isAllowedToGenerateRefreshToken() {
        return true;
    }

    @Override
    public AccessTokenRequestContext extractRequest(WebContext context) throws Throwable {
        OAuth20ConfigurationContext configurationContext = (OAuth20ConfigurationContext)this.getConfigurationContext().getObject();
        Optional grantType = configurationContext.getRequestParameterResolver().resolveRequestParameter(context, "grant_type");
        LOGGER.debug("OAuth grant type is [{}]", (Object)grantType);
        String redirectUri = this.getRegisteredServiceIdentifierFromRequest(context);
        OAuthRegisteredService registeredService = this.getOAuthRegisteredServiceBy(context);
        FunctionUtils.throwIf((registeredService == null ? 1 : 0) != 0, () -> UnauthorizedServiceException.denied((String)"Unable to locate service in registry for redirect URI %s ".formatted(redirectUri)));
        Set requestedScopes = configurationContext.getRequestParameterResolver().resolveRequestScopes(context);
        LOGGER.debug("Requested scopes are [{}]", (Object)requestedScopes);
        OAuth20Token token = this.getOAuthTokenFromRequest(context);
        this.ensureTokenIsValid(token);
        Set<String> scopes = this.extractRequestedScopesByToken(requestedScopes, token, context);
        WebApplicationService service = (WebApplicationService)configurationContext.getWebApplicationServiceServiceFactory().createService(redirectUri);
        boolean generateRefreshToken = AccessTokenAuthorizationCodeGrantRequestExtractor.isAllowedToGenerateRefreshToken() && registeredService.isGenerateRefreshToken();
        AccessTokenRequestContext.AccessTokenRequestContextBuilder builder = AccessTokenRequestContext.builder().scopes(scopes).service((Service)service).authentication(token.getAuthentication()).registeredService(registeredService).grantType(this.getGrantType()).generateRefreshToken(generateRefreshToken).token(token).claims(token.getClaims()).ticketGrantingTicket(this.fetchTicketGrantingTicket(token));
        return this.extractInternal(context, builder.build());
    }

    public boolean supports(WebContext context) {
        String grantType = ((OAuth20ConfigurationContext)this.getConfigurationContext().getObject()).getRequestParameterResolver().resolveRequestParameter(context, "grant_type").orElse("");
        return OAuth20Utils.isGrantType(grantType, this.getGrantType());
    }

    public OAuth20GrantTypes getGrantType() {
        return OAuth20GrantTypes.AUTHORIZATION_CODE;
    }

    public OAuth20ResponseTypes getResponseType() {
        return OAuth20ResponseTypes.NONE;
    }

    protected boolean ensureTokenIsValid(OAuth20Token token) {
        boolean validStatefulTicket = !token.isStateless() && token.isCode() && ((OAuth20ConfigurationContext)this.getConfigurationContext().getObject()).getTicketRegistry().getTicket(token.getTicketGrantingTicket().getId()) != null;
        return validStatefulTicket || token.isStateless() && token.getAuthentication() != null && !token.isExpired();
    }

    protected Set<String> extractRequestedScopesByToken(Set<String> requestedScopes, OAuth20Token token, WebContext context) {
        if (requestedScopes.isEmpty()) {
            return new TreeSet<String>(token.getScopes());
        }
        if (!token.getScopes().containsAll(requestedScopes)) {
            LOGGER.error("Requested scopes [{}] exceed the granted scopes [{}] for token [{}]", new Object[]{requestedScopes, token.getScopes(), token.getId()});
            throw new OAuth20UnauthorizedScopeRequestException(token.getId());
        }
        return new TreeSet<String>(requestedScopes);
    }

    protected AccessTokenRequestContext extractInternal(WebContext context, AccessTokenRequestContext tokenRequestContext) {
        return tokenRequestContext;
    }

    protected String getRegisteredServiceIdentifierFromRequest(WebContext context) {
        return ((OAuth20ConfigurationContext)this.getConfigurationContext().getObject()).getRequestParameterResolver().resolveRequestParameter(context, "redirect_uri").orElse("");
    }

    protected String getOAuthParameterName() {
        return "code";
    }

    protected String getOAuthParameter(WebContext context) {
        return ((OAuth20ConfigurationContext)this.getConfigurationContext().getObject()).getRequestParameterResolver().resolveRequestParameter(context, this.getOAuthParameterName()).orElse("");
    }

    protected OAuth20Token getOAuthTokenFromRequest(WebContext context) {
        String id = this.getOAuthParameter(context);
        return (OAuth20Token)((OAuth20ConfigurationContext)this.getConfigurationContext().getObject()).getTicketRegistry().getTicket(id, OAuth20Token.class);
    }

    protected OAuthRegisteredService getOAuthRegisteredServiceBy(WebContext context) {
        OAuth20ConfigurationContext configurationContext = (OAuth20ConfigurationContext)this.getConfigurationContext().getObject();
        CallContext callContext = new CallContext(context, configurationContext.getSessionStore());
        String clientId = (String)configurationContext.getRequestParameterResolver().resolveClientIdAndClientSecret(callContext).getLeft();
        String redirectUri = this.getRegisteredServiceIdentifierFromRequest(context);
        OAuthRegisteredService registeredService = StringUtils.isNotBlank((CharSequence)clientId) ? OAuth20Utils.getRegisteredOAuthServiceByClientId(configurationContext.getServicesManager(), clientId) : OAuth20Utils.getRegisteredOAuthServiceByRedirectUri(configurationContext.getServicesManager(), redirectUri);
        FunctionUtils.doIf((registeredService == null ? 1 : 0) != 0, param -> LOGGER.warn("Unable to locate registered service for clientId [{}] or redirectUri [{}]", (Object)clientId, (Object)redirectUri), ex -> LOGGER.debug("Located registered service [{}]", (Object)registeredService)).accept(registeredService);
        return registeredService;
    }

    protected Ticket fetchTicketGrantingTicket(OAuth20Token token) {
        try {
            if (token.getTicketGrantingTicket() != null) {
                String id = token.getTicketGrantingTicket().getId();
                OAuth20ConfigurationContext configurationContext = (OAuth20ConfigurationContext)this.getConfigurationContext().getObject();
                TicketGrantingTicket ticketGrantingTicket = (TicketGrantingTicket)configurationContext.getTicketRegistry().getTicket(id, TicketGrantingTicket.class);
                FunctionUtils.doUnchecked(__ -> {
                    token.assignTicketGrantingTicket((Ticket)ticketGrantingTicket);
                    configurationContext.getTicketRegistry().updateTicket((Ticket)token);
                }, (Object[])new Object[0]);
                return ticketGrantingTicket;
            }
        }
        catch (InvalidTicketException e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        return null;
    }
}

