/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.ext;

import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.springframework.beans.factory.ObjectProvider;

public abstract class BaseAccessTokenGrantRequestExtractor<T extends OAuth20ConfigurationContext>
implements AccessTokenGrantRequestExtractor {
    private final ObjectProvider<T> configurationContext;

    public AccessTokenRequestContext extract(WebContext webContext) throws Throwable {
        AccessTokenRequestContext tokenRequestContext = this.extractRequest(webContext);
        this.extractUserProfile(webContext).ifPresent(profile -> {
            if (profile.containsAttribute("DPoPConfirmation")) {
                tokenRequestContext.setDpopConfirmation(profile.getAttribute("DPoPConfirmation").toString());
            }
            if (profile.containsAttribute("DPoP")) {
                tokenRequestContext.setDpop(profile.getAttribute("DPoP").toString());
            }
            tokenRequestContext.setUserProfile(profile);
        });
        return tokenRequestContext;
    }

    protected Optional<UserProfile> extractUserProfile(WebContext webContext) {
        return new ProfileManager(webContext, ((OAuth20ConfigurationContext)this.configurationContext.getObject()).getSessionStore()).getProfile();
    }

    protected abstract AccessTokenRequestContext extractRequest(WebContext var1) throws Throwable;

    @Generated
    protected BaseAccessTokenGrantRequestExtractor(ObjectProvider<T> configurationContext) {
        this.configurationContext = configurationContext;
    }

    @Generated
    public ObjectProvider<T> getConfigurationContext() {
        return this.configurationContext;
    }
}

