/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyObjectCR;
import org.apache.syncope.common.lib.request.AnyObjectUR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.RelationshipTypeDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Groupable;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Relatable;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.data.AnyObjectDataBinder;
import org.apache.syncope.core.provisioning.api.jexl.JexlTools;
import org.apache.syncope.core.provisioning.java.data.AnyDataBinder;
import org.apache.syncope.core.provisioning.java.pushpull.OutboundMatcher;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public class AnyObjectDataBinderImpl
extends AnyDataBinder
implements AnyObjectDataBinder {
    public AnyObjectDataBinderImpl(AnyTypeDAO anyTypeDAO, RealmSearchDAO realmSearchDAO, AnyTypeClassDAO anyTypeClassDAO, AnyObjectDAO anyObjectDAO, UserDAO userDAO, GroupDAO groupDAO, PlainSchemaDAO plainSchemaDAO, ExternalResourceDAO resourceDAO, RelationshipTypeDAO relationshipTypeDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, DerAttrHandler derAttrHandler, MappingManager mappingManager, IntAttrNameParser intAttrNameParser, OutboundMatcher outboundMatcher, PlainAttrValidationManager validator, JexlTools jexlTools) {
        super(anyTypeDAO, realmSearchDAO, anyTypeClassDAO, anyObjectDAO, userDAO, groupDAO, plainSchemaDAO, resourceDAO, relationshipTypeDAO, entityFactory, anyUtilsFactory, derAttrHandler, mappingManager, intAttrNameParser, outboundMatcher, validator, jexlTools);
    }

    @Transactional(readOnly=true)
    public AnyObjectTO getAnyObjectTO(String key) {
        return this.getAnyObjectTO((AnyObject)this.anyObjectDAO.authFind(key), true);
    }

    @Transactional(readOnly=true)
    public AnyObjectTO getAnyObjectTO(AnyObject anyObject, boolean details) {
        AnyObjectTO anyObjectTO = new AnyObjectTO();
        anyObjectTO.setType(anyObject.getType().getKey());
        anyObjectTO.setKey(anyObject.getKey());
        anyObjectTO.setName(anyObject.getName());
        anyObjectTO.setStatus(anyObject.getStatus());
        anyObjectTO.setCreator(anyObject.getCreator());
        anyObjectTO.setCreationDate(anyObject.getCreationDate());
        anyObjectTO.setCreationContext(anyObject.getCreationContext());
        anyObjectTO.setLastModifier(anyObject.getLastModifier());
        anyObjectTO.setLastChangeDate(anyObject.getLastChangeDate());
        anyObjectTO.setLastChangeContext(anyObject.getLastChangeContext());
        AnyObjectDataBinderImpl.fillTO((Any)anyObject, (AnyTO)anyObjectTO, this.derAttrHandler.getValues((Any)anyObject), this.anyObjectDAO.findAllResources(anyObject));
        if (details) {
            anyObjectTO.getRelationships().addAll(this.anyObjectDAO.findAllRelationships(anyObject).stream().map(relationship -> AnyObjectDataBinderImpl.getRelationshipTO(anyObject.getPlainAttrs(relationship), this.derAttrHandler.getValues((Relatable)anyObject, relationship), relationship.getType().getKey(), relationship.getLeftEnd().getKey().equals(anyObject.getKey()) ? RelationshipTO.End.LEFT : RelationshipTO.End.RIGHT, relationship.getLeftEnd().getKey().equals(anyObject.getKey()) ? relationship.getRightEnd() : relationship.getLeftEnd())).toList());
            anyObjectTO.getMemberships().addAll(anyObject.getMemberships().stream().map(membership -> AnyObjectDataBinderImpl.getMembershipTO(anyObject.getPlainAttrs((Membership)membership), this.derAttrHandler.getValues((Groupable)anyObject, (Membership)membership), (Membership<? extends Any>)membership)).toList());
        }
        return anyObjectTO;
    }

    public void create(AnyObject anyObject, AnyObjectCR anyObjectCR) {
        AnyType type = (AnyType)this.anyTypeDAO.findById(anyObjectCR.getType()).orElseThrow(() -> {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAnyType);
            sce.getElements().add(anyObjectCR.getType());
            return sce;
        });
        anyObject.setType(type);
        AnyObjectTO anyTO = new AnyObjectTO();
        EntityTOUtils.toAnyTO((AnyCR)anyObjectCR, (AnyTO)anyTO);
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(AnyTypeKind.ANY_OBJECT);
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        SyncopeClientException invalidGroups = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidGroup);
        if (anyObjectCR.getName() == null) {
            LOG.error("No name specified for this anyObject");
            invalidGroups.getElements().add("No name specified for this anyObject");
        } else {
            anyObject.setName(anyObjectCR.getName());
        }
        Realm realm = this.realmSearchDAO.findByFullPath(anyObjectCR.getRealm()).orElse(null);
        if (realm == null) {
            SyncopeClientException noRealm = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
            noRealm.getElements().add("Invalid or null realm specified: " + anyObjectCR.getRealm());
            scce.addException(noRealm);
        }
        anyObject.setRealm(realm);
        this.fill((AnyTO)anyTO, (Relatable<?, ?>)anyObject, (AnyCR)anyObjectCR, this.anyUtilsFactory.getInstance(AnyTypeKind.ANY_OBJECT), scce);
        this.memberships(anyObjectCR.getMemberships(), (AnyTO)anyTO, (Groupable<?, ?, ?>)anyObject, anyUtils, scce);
        if (scce.hasExceptions()) {
            throw scce;
        }
    }

    public PropagationByResource<String> update(AnyObject toBeUpdated, AnyObjectUR anyObjectUR) {
        AnyObject anyObject = (AnyObject)this.anyObjectDAO.save((Entity)toBeUpdated);
        AnyObjectTO anyTO = AnyOperations.patch((AnyObjectTO)this.getAnyObjectTO(anyObject, true), (AnyObjectUR)anyObjectUR);
        PropagationByResource propByRes = new PropagationByResource();
        Map<String, ConnObject> beforeOnResources = this.onResources((Any)anyObject, this.anyObjectDAO.findAllResourceKeys(anyObject.getKey()), null, Set.of());
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(AnyTypeKind.ANY_OBJECT);
        this.setRealm((Any)anyObject, (AnyUR)anyObjectUR);
        if (anyObjectUR.getName() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)anyObjectUR.getName().getValue()))) {
            anyObject.setName((String)anyObjectUR.getName().getValue());
        }
        this.fill((AnyTO)anyTO, (Relatable<?, ?>)anyObject, (AnyUR)anyObjectUR, (PropagationByResource<String>)propByRes, anyUtils, scce);
        this.memberships(anyObjectUR.getMemberships(), (AnyTO)anyTO, (Groupable<?, ?, ?>)anyObject, group -> {}, (PropagationByResource<String>)propByRes, anyUtils, scce);
        if (scce.hasExceptions()) {
            throw scce;
        }
        AnyObject saved = (AnyObject)this.anyObjectDAO.save((Entity)anyObject);
        propByRes.merge(this.propByRes(beforeOnResources, this.onResources((Any)saved, this.anyObjectDAO.findAllResourceKeys(anyObject.getKey()), null, Set.of())));
        return propByRes;
    }
}

