/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.matching.matcher;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.HttpConstants;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.matching.matcher.Matcher;
import org.pac4j.core.util.CommonHelper;

public class CorsMatcher
implements Matcher {
    private String allowOrigin;
    private String exposeHeaders;
    private int maxAge = -1;
    private Boolean allowCredentials;
    private Set<HttpConstants.HTTP_METHOD> allowMethods;
    private String allowHeaders;

    @Override
    public boolean matches(CallContext ctx) {
        WebContext webContext = ctx.webContext();
        CommonHelper.assertNotBlank("allowOrigin", this.allowOrigin);
        webContext.setResponseHeader("Access-Control-Allow-Origin", this.allowOrigin);
        if (StringUtils.isNotBlank((CharSequence)this.exposeHeaders)) {
            webContext.setResponseHeader("Access-Control-Expose-Headers", this.exposeHeaders);
        }
        if (this.maxAge != -1) {
            webContext.setResponseHeader("Access-Control-Max-Age", "" + this.maxAge);
        }
        if (this.allowCredentials != null && this.allowCredentials.booleanValue()) {
            webContext.setResponseHeader("Access-Control-Allow-Credentials", this.allowCredentials.toString());
        }
        if (this.allowMethods != null) {
            String methods = this.allowMethods.stream().map(Enum::toString).collect(Collectors.joining(", "));
            webContext.setResponseHeader("Access-Control-Allow-Methods", methods);
        }
        if (StringUtils.isNotBlank((CharSequence)this.allowHeaders)) {
            webContext.setResponseHeader("Access-Control-Allow-Headers", this.allowHeaders);
        }
        return true;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getAllowOrigin() {
        return this.allowOrigin;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getExposeHeaders() {
        return this.exposeHeaders;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxAge() {
        return this.maxAge;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Boolean getAllowCredentials() {
        return this.allowCredentials;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Set<HttpConstants.HTTP_METHOD> getAllowMethods() {
        return this.allowMethods;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getAllowHeaders() {
        return this.allowHeaders;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAllowOrigin(String allowOrigin) {
        this.allowOrigin = allowOrigin;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setExposeHeaders(String exposeHeaders) {
        this.exposeHeaders = exposeHeaders;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAllowCredentials(Boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAllowMethods(Set<HttpConstants.HTTP_METHOD> allowMethods) {
        this.allowMethods = allowMethods;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAllowHeaders(String allowHeaders) {
        this.allowHeaders = allowHeaders;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "CorsMatcher(allowOrigin=" + this.allowOrigin + ", exposeHeaders=" + this.exposeHeaders + ", maxAge=" + this.maxAge + ", allowCredentials=" + this.allowCredentials + ", allowMethods=" + this.allowMethods + ", allowHeaders=" + this.allowHeaders + ")";
    }
}

