/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.notifications.mail;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.support.email.EmailProperties;
import org.apereo.cas.util.CollectionUtils;

public class EmailMessageRequest {
    private final Principal principal;
    private final String attribute;
    private final EmailProperties emailProperties;
    private final String body;
    private final List<String> to;
    private final Locale locale;
    private final String tenant;
    private final Map<String, Object> context;

    public boolean hasAttributeValue() {
        return StringUtils.isNotBlank((CharSequence)this.attribute) && this.principal.getAttributes().containsKey(this.attribute);
    }

    public List<String> getAttributeValue() {
        List value = (List)this.principal.getAttributes().get(this.attribute);
        return (List)CollectionUtils.toCollection((Object)value, ArrayList.class);
    }

    public List<String> getRecipients() {
        return this.hasAttributeValue() ? this.getAttributeValue() : (List)ObjectUtils.getIfNull(this.getTo(), List.of());
    }

    @Generated
    private static Map<String, Object> $default$context() {
        return new LinkedHashMap<String, Object>();
    }

    @Generated
    protected EmailMessageRequest(EmailMessageRequestBuilder<?, ?> b) {
        this.principal = b.principal;
        this.attribute = b.attribute;
        this.emailProperties = b.emailProperties;
        this.body = b.body;
        this.to = b.to;
        this.locale = b.locale;
        this.tenant = b.tenant;
        this.context = b.context$set ? b.context$value : EmailMessageRequest.$default$context();
    }

    @Generated
    public static EmailMessageRequestBuilder<?, ?> builder() {
        return new EmailMessageRequestBuilderImpl();
    }

    @Generated
    public Principal getPrincipal() {
        return this.principal;
    }

    @Generated
    public String getAttribute() {
        return this.attribute;
    }

    @Generated
    public EmailProperties getEmailProperties() {
        return this.emailProperties;
    }

    @Generated
    public String getBody() {
        return this.body;
    }

    @Generated
    public List<String> getTo() {
        return this.to;
    }

    @Generated
    public Locale getLocale() {
        return this.locale;
    }

    @Generated
    public String getTenant() {
        return this.tenant;
    }

    @Generated
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Generated
    public EmailMessageRequest withPrincipal(Principal principal) {
        return this.principal == principal ? this : new EmailMessageRequest(principal, this.attribute, this.emailProperties, this.body, this.to, this.locale, this.tenant, this.context);
    }

    @Generated
    public EmailMessageRequest withAttribute(String attribute) {
        return this.attribute == attribute ? this : new EmailMessageRequest(this.principal, attribute, this.emailProperties, this.body, this.to, this.locale, this.tenant, this.context);
    }

    @Generated
    public EmailMessageRequest withEmailProperties(EmailProperties emailProperties) {
        return this.emailProperties == emailProperties ? this : new EmailMessageRequest(this.principal, this.attribute, emailProperties, this.body, this.to, this.locale, this.tenant, this.context);
    }

    @Generated
    public EmailMessageRequest withBody(String body) {
        return this.body == body ? this : new EmailMessageRequest(this.principal, this.attribute, this.emailProperties, body, this.to, this.locale, this.tenant, this.context);
    }

    @Generated
    public EmailMessageRequest withTo(List<String> to) {
        return this.to == to ? this : new EmailMessageRequest(this.principal, this.attribute, this.emailProperties, this.body, to, this.locale, this.tenant, this.context);
    }

    @Generated
    public EmailMessageRequest withLocale(Locale locale) {
        return this.locale == locale ? this : new EmailMessageRequest(this.principal, this.attribute, this.emailProperties, this.body, this.to, locale, this.tenant, this.context);
    }

    @Generated
    public EmailMessageRequest withTenant(String tenant) {
        return this.tenant == tenant ? this : new EmailMessageRequest(this.principal, this.attribute, this.emailProperties, this.body, this.to, this.locale, tenant, this.context);
    }

    @Generated
    public EmailMessageRequest withContext(Map<String, Object> context) {
        return this.context == context ? this : new EmailMessageRequest(this.principal, this.attribute, this.emailProperties, this.body, this.to, this.locale, this.tenant, context);
    }

    @Generated
    public EmailMessageRequest(Principal principal, String attribute, EmailProperties emailProperties, String body, List<String> to, Locale locale, String tenant, Map<String, Object> context) {
        this.principal = principal;
        this.attribute = attribute;
        this.emailProperties = emailProperties;
        this.body = body;
        this.to = to;
        this.locale = locale;
        this.tenant = tenant;
        this.context = context;
    }

    @Generated
    public static abstract class EmailMessageRequestBuilder<C extends EmailMessageRequest, B extends EmailMessageRequestBuilder<C, B>> {
        @Generated
        private Principal principal;
        @Generated
        private String attribute;
        @Generated
        private EmailProperties emailProperties;
        @Generated
        private String body;
        @Generated
        private List<String> to;
        @Generated
        private Locale locale;
        @Generated
        private String tenant;
        @Generated
        private boolean context$set;
        @Generated
        private Map<String, Object> context$value;

        @Generated
        public B principal(Principal principal) {
            this.principal = principal;
            return this.self();
        }

        @Generated
        public B attribute(String attribute) {
            this.attribute = attribute;
            return this.self();
        }

        @Generated
        public B emailProperties(EmailProperties emailProperties) {
            this.emailProperties = emailProperties;
            return this.self();
        }

        @Generated
        public B body(String body) {
            this.body = body;
            return this.self();
        }

        @Generated
        public B to(List<String> to) {
            this.to = to;
            return this.self();
        }

        @Generated
        public B locale(Locale locale) {
            this.locale = locale;
            return this.self();
        }

        @Generated
        public B tenant(String tenant) {
            this.tenant = tenant;
            return this.self();
        }

        @Generated
        public B context(Map<String, Object> context) {
            this.context$value = context;
            this.context$set = true;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "EmailMessageRequest.EmailMessageRequestBuilder(principal=" + String.valueOf(this.principal) + ", attribute=" + this.attribute + ", emailProperties=" + String.valueOf(this.emailProperties) + ", body=" + this.body + ", to=" + String.valueOf(this.to) + ", locale=" + String.valueOf(this.locale) + ", tenant=" + this.tenant + ", context$value=" + String.valueOf(this.context$value) + ")";
        }
    }

    @Generated
    private static final class EmailMessageRequestBuilderImpl
    extends EmailMessageRequestBuilder<EmailMessageRequest, EmailMessageRequestBuilderImpl> {
        @Generated
        private EmailMessageRequestBuilderImpl() {
        }

        @Override
        @Generated
        protected EmailMessageRequestBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public EmailMessageRequest build() {
            return new EmailMessageRequest(this);
        }
    }
}

