/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.util.concurrent.TimeUnit;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.wicket.ws.RefreshWebSocketBehavior;
import org.apache.syncope.client.console.widgets.AnyByRealmWidget;
import org.apache.syncope.client.console.widgets.CompletenessWidget;
import org.apache.syncope.client.console.widgets.LoadWidget;
import org.apache.syncope.client.console.widgets.NumberWidget;
import org.apache.syncope.client.console.widgets.UsersByStatusWidget;
import org.apache.syncope.common.lib.info.NumbersInfo;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.protocol.ws.api.WebSocketRequestHandler;

public class DashboardOverviewPanel
extends Panel {
    private static final long serialVersionUID = 5989039374050260225L;
    private final NumberWidget totalUsers;
    private final NumberWidget totalGroups;
    private final NumberWidget totalAny1OrRoles;
    private final NumberWidget totalAny2OrResources;
    private final UsersByStatusWidget usersByStatus;
    private final CompletenessWidget completeness;
    private final AnyByRealmWidget anyByRealm;
    private final LoadWidget load;

    private static TotalInfo buildTotalAny1OrRoles(NumbersInfo numbers) {
        String icon;
        String label;
        long number;
        if (numbers.getAnyType1() == null) {
            number = numbers.getTotalRoles();
            label = new ResourceModel("roles").getObject();
            icon = "fas fa-users";
        } else {
            number = numbers.getTotalAny1();
            label = numbers.getAnyType1();
            icon = "ion ion-gear-a";
        }
        return new TotalInfo(number, label, icon);
    }

    private static TotalInfo buildTotalAny2OrResources(NumbersInfo numbers) {
        String icon;
        String label;
        long number;
        if (numbers.getAnyType2() == null) {
            number = numbers.getTotalResources();
            label = new ResourceModel("resources").getObject();
            icon = "fa fa-database";
        } else {
            number = numbers.getTotalAny2();
            label = numbers.getAnyType2();
            icon = "ion ion-gear-a";
        }
        return new TotalInfo(number, label, icon);
    }

    public DashboardOverviewPanel(String id) {
        super(id);
        NumbersInfo numbers = SyncopeConsoleSession.get().getAnonymousClient().numbers();
        WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        this.totalUsers = new NumberWidget("totalUsers", "text-bg-warning", numbers.getTotalUsers(), new ResourceModel("users").getObject(), "ion ion-person");
        container.add(new Component[]{this.totalUsers});
        this.totalGroups = new NumberWidget("totalGroups", "text-bg-danger", numbers.getTotalGroups(), new ResourceModel("groups").getObject(), "ion ion-person-stalker");
        container.add(new Component[]{this.totalGroups});
        TotalInfo built = DashboardOverviewPanel.buildTotalAny1OrRoles(numbers);
        this.totalAny1OrRoles = new NumberWidget("totalAny1OrRoles", "text-bg-success", built.number(), built.label(), built.icon());
        container.add(new Component[]{this.totalAny1OrRoles});
        built = DashboardOverviewPanel.buildTotalAny2OrResources(numbers);
        this.totalAny2OrResources = new NumberWidget("totalAny2OrResources", "bg-info", built.number(), built.label(), built.icon());
        container.add(new Component[]{this.totalAny2OrResources});
        this.usersByStatus = new UsersByStatusWidget("usersByStatus", numbers.getUsersByStatus());
        container.add(new Component[]{this.usersByStatus});
        this.completeness = new CompletenessWidget("completeness", numbers.getConfCompleteness());
        container.add(new Component[]{this.completeness});
        this.anyByRealm = new AnyByRealmWidget("anyByRealm", numbers.getUsersByRealm(), numbers.getGroupsByRealm(), numbers.getAnyType1(), numbers.getAny1ByRealm(), numbers.getAnyType2(), numbers.getAny2ByRealm());
        container.add(new Component[]{this.anyByRealm});
        this.load = new LoadWidget("load", SyncopeConsoleSession.get().getAnonymousClient().system());
        container.add(new Component[]{this.load});
        container.add(new Behavior[]{new RefreshWebSocketBehavior(){
            private static final long serialVersionUID = -7095269057058900157L;

            @Override
            protected void onTimer(WebSocketRequestHandler handler) {
                TotalInfo updatedBuild;
                NumbersInfo numbers = SyncopeConsoleSession.get().getAnonymousClient().numbers();
                if (DashboardOverviewPanel.this.totalUsers.refresh(numbers.getTotalUsers())) {
                    handler.add(new Component[]{DashboardOverviewPanel.this.totalUsers});
                }
                if (DashboardOverviewPanel.this.totalGroups.refresh(numbers.getTotalGroups())) {
                    handler.add(new Component[]{DashboardOverviewPanel.this.totalGroups});
                }
                if (DashboardOverviewPanel.this.totalAny1OrRoles.refresh((updatedBuild = DashboardOverviewPanel.buildTotalAny1OrRoles(numbers)).number())) {
                    handler.add(new Component[]{DashboardOverviewPanel.this.totalAny1OrRoles});
                }
                if (DashboardOverviewPanel.this.totalAny2OrResources.refresh((updatedBuild = DashboardOverviewPanel.buildTotalAny2OrResources(numbers)).number())) {
                    handler.add(new Component[]{DashboardOverviewPanel.this.totalAny2OrResources});
                }
                if (DashboardOverviewPanel.this.usersByStatus.refresh(numbers.getUsersByStatus())) {
                    handler.add(new Component[]{DashboardOverviewPanel.this.usersByStatus});
                }
                if (DashboardOverviewPanel.this.completeness.refresh(numbers.getConfCompleteness())) {
                    handler.add(new Component[]{DashboardOverviewPanel.this.completeness});
                }
                if (DashboardOverviewPanel.this.anyByRealm.refresh(numbers.getUsersByRealm(), numbers.getGroupsByRealm(), numbers.getAnyType1(), numbers.getAny1ByRealm(), numbers.getAnyType2(), numbers.getAny2ByRealm())) {
                    handler.add(new Component[]{DashboardOverviewPanel.this.anyByRealm});
                }
                DashboardOverviewPanel.this.load.refresh(SyncopeConsoleSession.get().getAnonymousClient().system());
                handler.add(new Component[]{DashboardOverviewPanel.this.load});
            }
        }.schedule(60L, TimeUnit.SECONDS)});
    }

    private record TotalInfo(Long number, String label, String icon) {
    }
}

