/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.commons.ImplementationInfoProvider;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.types.ImplementationEngine;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.io.IOUtils;

public class ImplementationModalPanel
extends AbstractModalPanel<ImplementationTO> {
    private static final long serialVersionUID = 5283548960927517342L;
    protected static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    @SpringBean
    protected ImplementationRestClient implementationRestClient;
    protected final ImplementationTO implementation;
    protected final ImplementationInfoProvider.ViewMode viewMode;
    protected boolean create = false;

    public ImplementationModalPanel(BaseModal<ImplementationTO> modal, final ImplementationTO implementation, PageReference pageRef) {
        super(modal, pageRef);
        String templateClassName;
        this.implementation = implementation;
        this.viewMode = SyncopeWebApplication.get().getImplementationInfoProvider().getViewMode(implementation);
        this.create = implementation.getKey() == null;
        this.add(new Component[]{new AjaxTextFieldPanel("key", "key", (IModel)new PropertyModel((Object)implementation, "key"), false).addRequiredLabel().setEnabled(this.create)});
        List<String> classes = SyncopeWebApplication.get().getImplementationInfoProvider().getClasses(implementation, this.viewMode);
        AjaxDropDownChoicePanel javaClass = new AjaxDropDownChoicePanel("javaClass", "Class", (IModel)new PropertyModel((Object)implementation, "body"));
        javaClass.setNullValid(false);
        javaClass.setChoices(classes);
        javaClass.addRequiredLabel();
        javaClass.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        javaClass.setVisible(this.viewMode == ImplementationInfoProvider.ViewMode.JAVA_CLASS);
        this.add(new Component[]{javaClass});
        final AjaxDropDownChoicePanel jsonClass = new AjaxDropDownChoicePanel("jsonClass", "Class", (IModel)new Model());
        jsonClass.setNullValid(false);
        jsonClass.setChoices(classes);
        jsonClass.addRequiredLabel();
        jsonClass.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        jsonClass.setVisible(this.viewMode == ImplementationInfoProvider.ViewMode.JSON_BODY);
        if (this.viewMode == ImplementationInfoProvider.ViewMode.JSON_BODY && StringUtils.isNotBlank((CharSequence)implementation.getBody())) {
            try {
                JsonNode node = MAPPER.readTree(implementation.getBody());
                if (node.has("_class")) {
                    jsonClass.setModelObject((Serializable)((Object)node.get("_class").asText()));
                }
            }
            catch (IOException e) {
                LOG.error("Could not parse as JSON payload: {}", (Object)implementation.getBody(), (Object)e);
            }
        }
        jsonClass.setReadOnly(jsonClass.getModelObject() != null);
        this.add(new Component[]{jsonClass});
        WebMarkupContainer groovyClassContainer = new WebMarkupContainer("groovyClassContainer");
        groovyClassContainer.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        groovyClassContainer.setVisible(this.viewMode != ImplementationInfoProvider.ViewMode.JAVA_CLASS);
        this.add(new Component[]{groovyClassContainer});
        if (StringUtils.isBlank((CharSequence)implementation.getBody()) && implementation.getEngine() == ImplementationEngine.GROOVY && (templateClassName = SyncopeWebApplication.get().getImplementationInfoProvider().getGroovyTemplateClassName(implementation.getType())) != null) {
            try {
                implementation.setBody(StringUtils.substringAfter((String)IOUtils.toString((InputStream)ImplementationModalPanel.class.getResourceAsStream("/org/apache/syncope/client/console/implementations/" + templateClassName + ".groovy")), (String)"*/\n"));
            }
            catch (IOException e) {
                LOG.error("Could not load the expected Groovy template {} for {}", new Object[]{templateClassName, implementation.getType(), e});
            }
        }
        TextArea groovyClass = new TextArea("groovyClass", (IModel)new PropertyModel((Object)implementation, "body"));
        groovyClass.setMarkupId("groovyClass").setOutputMarkupPlaceholderTag(true);
        groovyClass.setVisible(this.viewMode != ImplementationInfoProvider.ViewMode.JAVA_CLASS);
        groovyClass.setRequired(true);
        groovyClassContainer.add(new Component[]{groovyClass});
        jsonClass.add(new Behavior[]{new AjaxEventBehavior(this, "change"){
            private static final long serialVersionUID = 5538299138211283825L;
            final /* synthetic */ ImplementationModalPanel this$0;
            {
                this.this$0 = this$0;
                super(event);
            }

            protected void onEvent(AjaxRequestTarget target) {
                Class<?> clazz = SyncopeWebApplication.get().getImplementationInfoProvider().getClass(implementation.getType(), (String)((Object)jsonClass.getModelObject()));
                if (clazz != null) {
                    try {
                        target.appendJavaScript((CharSequence)("editor.getDoc().setValue('" + MAPPER.writeValueAsString(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])) + "');"));
                    }
                    catch (Exception e) {
                        AbstractModalPanel.LOG.error("Could not generate a value for {}", (Object)jsonClass.getModelObject(), (Object)e);
                    }
                }
            }
        }});
    }

    @Override
    public ImplementationTO getItem() {
        return this.implementation;
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (this.viewMode != ImplementationInfoProvider.ViewMode.JAVA_CLASS) {
            response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)("editor = CodeMirror.fromTextArea(document.getElementById('groovyClassForm').children['groovyClass'], {  readOnly: false,   lineNumbers: true,   lineWrapping: true,   matchBrackets: true,  autoCloseBrackets: true," + (this.viewMode == ImplementationInfoProvider.ViewMode.GROOVY_BODY ? "  mode: 'text/x-groovy'," : "") + "  autoRefresh: true});editor.on('change', updateTextArea);")));
        }
    }

    @Override
    public void onSubmit(AjaxRequestTarget target) {
        try {
            if (this.create) {
                this.implementationRestClient.create(this.implementation);
            } else {
                this.implementationRestClient.update(this.implementation);
            }
            this.modal.close((IPartialPageRequestHandler)target);
            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
        }
        catch (Exception e) {
            LOG.error("While creating or updating Implementation", (Throwable)e);
            SyncopeConsoleSession.get().onException(e);
        }
        ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
    }
}

