/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal.resolvers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PrincipalElectionStrategy;
import org.apereo.cas.authentication.principal.NullPrincipal;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.merger.AttributeMerger;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainingPrincipalResolver
implements PrincipalResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ChainingPrincipalResolver.class);
    private final PrincipalFactory principalFactory = PrincipalFactoryUtils.newPrincipalFactory();
    private final PrincipalElectionStrategy principalElectionStrategy;
    private final TenantExtractor tenantExtractor;
    private final List<PrincipalResolver> registeredPrincipalResolvers;
    private final CasConfigurationProperties casProperties;

    public Principal resolve(Credential credential, Optional<Principal> principal, Optional<AuthenticationHandler> handler, Optional<Service> service) throws Throwable {
        List<? extends PrincipalResolver> principalResolvers = this.determinePrincipalResolvers(credential);
        List<Principal> principals = this.resolvePrincipals(principalResolvers, credential, principal, handler, service);
        if (principals.isEmpty()) {
            LOGGER.warn("None of the principal resolvers in the chain were able to produce a principal");
            return NullPrincipal.getInstance();
        }
        HashMap attributes = new HashMap();
        AttributeMerger merger = CoreAuthenticationUtils.getAttributeMerger(this.casProperties.getAuthn().getAttributeRepository().getCore().getMerger());
        principals.forEach(resolvedPrincipal -> {
            if (resolvedPrincipal != null) {
                LOGGER.debug("Resolved principal [{}]", resolvedPrincipal);
                Map principalAttributes = resolvedPrincipal.getAttributes();
                if (principalAttributes != null && !principalAttributes.isEmpty()) {
                    LOGGER.debug("Adding attributes [{}] for the final principal", (Object)principalAttributes);
                    attributes.putAll(CoreAuthenticationUtils.mergeAttributes(attributes, principalAttributes, merger));
                }
            }
        });
        return this.principalElectionStrategy.nominate(principals, attributes);
    }

    protected List<? extends PrincipalResolver> determinePrincipalResolvers(Credential credential) {
        return List.copyOf(this.registeredPrincipalResolvers);
    }

    protected List<Principal> resolvePrincipals(List<? extends PrincipalResolver> resolvers, Credential credential, Optional<Principal> principal, Optional<AuthenticationHandler> handler, Optional<Service> service) {
        return resolvers.stream().filter(resolver -> resolver.supports(credential)).map(resolver -> {
            LOGGER.debug("Invoking principal resolver [{}]", (Object)resolver.getName());
            Principal resolvedPrincipal = (Principal)FunctionUtils.doUnchecked(() -> resolver.resolve(credential, principal, handler, service));
            if (resolvedPrincipal != null) {
                LOGGER.debug("Resolved principal [{}]", (Object)resolvedPrincipal);
            } else {
                LOGGER.debug("Unable to resolve principal via [{}]", (Object)resolver.getName());
            }
            return resolvedPrincipal;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean supports(Credential credential) {
        return this.registeredPrincipalResolvers.stream().anyMatch(r -> r.supports(credential));
    }

    @Generated
    public String toString() {
        return "ChainingPrincipalResolver(principalFactory=" + String.valueOf(this.principalFactory) + ", principalElectionStrategy=" + String.valueOf(this.principalElectionStrategy) + ", tenantExtractor=" + String.valueOf(this.tenantExtractor) + ", registeredPrincipalResolvers=" + String.valueOf(this.registeredPrincipalResolvers) + ", casProperties=" + String.valueOf(this.casProperties) + ")";
    }

    @Generated
    public ChainingPrincipalResolver(PrincipalElectionStrategy principalElectionStrategy, TenantExtractor tenantExtractor, List<PrincipalResolver> registeredPrincipalResolvers, CasConfigurationProperties casProperties) {
        this.principalElectionStrategy = principalElectionStrategy;
        this.tenantExtractor = tenantExtractor;
        this.registeredPrincipalResolvers = registeredPrincipalResolvers;
        this.casProperties = casProperties;
    }
}

