/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.authentication.adaptive.DefaultAdaptiveAuthenticationPolicy;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.authentication.adaptive.intel.BlackDotIPAddressIntelligenceService;
import org.apereo.cas.authentication.adaptive.intel.DefaultIPAddressIntelligenceService;
import org.apereo.cas.authentication.adaptive.intel.GroovyIPAddressIntelligenceService;
import org.apereo.cas.authentication.adaptive.intel.IPAddressIntelligenceService;
import org.apereo.cas.authentication.adaptive.intel.RestfulIPAddressIntelligenceService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.AdaptiveAuthenticationIPIntelligenceProperties;
import org.apereo.cas.configuration.model.core.authentication.AdaptiveAuthenticationProperties;
import org.apereo.cas.configuration.model.core.authentication.AuthenticationPolicyProperties;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.util.nativex.CasRuntimeHintsRegistrar;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Authentication})
@Configuration(value="CasCoreAuthenticationPolicyConfiguration", proxyBeanMethods=false)
class CasCoreAuthenticationPolicyConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreAuthenticationPolicyConfiguration.class);

    CasCoreAuthenticationPolicyConfiguration() {
    }

    @ConditionalOnMissingBean(name={"ipAddressIntelligenceService"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public IPAddressIntelligenceService ipAddressIntelligenceService(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, CasConfigurationProperties casProperties) {
        AdaptiveAuthenticationProperties adaptive = casProperties.getAuthn().getAdaptive();
        AdaptiveAuthenticationIPIntelligenceProperties intel = adaptive.getIpIntel();
        if (StringUtils.isNotBlank((CharSequence)intel.getRest().getUrl())) {
            return new RestfulIPAddressIntelligenceService(tenantExtractor, adaptive);
        }
        if (intel.getGroovy().getLocation() != null && CasRuntimeHintsRegistrar.notInNativeImage()) {
            return new GroovyIPAddressIntelligenceService(tenantExtractor, adaptive);
        }
        if (StringUtils.isNotBlank((CharSequence)intel.getBlackDot().getEmailAddress())) {
            return new BlackDotIPAddressIntelligenceService(tenantExtractor, adaptive);
        }
        return new DefaultIPAddressIntelligenceService(tenantExtractor, adaptive);
    }

    @Configuration(value="CasCoreAuthenticationPolicyPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreAuthenticationPolicyPlanConfiguration {
        CasCoreAuthenticationPolicyPlanConfiguration() {
        }

        @ConditionalOnMissingBean(name={"authenticationPolicyExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationEventExecutionPlanConfigurer authenticationPolicyExecutionPlanConfigurer(CasConfigurationProperties casProperties) {
            return plan -> {
                AuthenticationPolicyProperties policyProps = casProperties.getAuthn().getPolicy();
                Collection authPolicy = CoreAuthenticationUtils.newAuthenticationPolicy((AuthenticationPolicyProperties)policyProps);
                if (authPolicy != null) {
                    LOGGER.debug("Activated authentication policies are [{}]", (Object)authPolicy);
                    plan.registerAuthenticationPolicies(authPolicy);
                }
            };
        }

        @ConditionalOnMissingBean(name={"adaptiveAuthenticationPolicy"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy(CasConfigurationProperties casProperties, @Qualifier(value="ipAddressIntelligenceService") IPAddressIntelligenceService ipAddressIntelligenceService, @Qualifier(value="geoLocationService") ObjectProvider<GeoLocationService> geoLocationService) {
            return new DefaultAdaptiveAuthenticationPolicy((GeoLocationService)geoLocationService.getIfAvailable(), ipAddressIntelligenceService, casProperties.getAuthn().getAdaptive());
        }
    }
}

