/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.policies;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.rest.AuthModuleRestClient;
import org.apache.syncope.client.console.rest.PolicyRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.common.lib.policy.AuthPolicyTO;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.to.AuthModuleTO;
import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class AuthPolicyModalPanel
extends AbstractModalPanel<AuthPolicyTO> {
    private static final long serialVersionUID = -7210166323800567306L;
    @SpringBean
    protected PolicyRestClient policyRestClient;
    @SpringBean
    protected AuthModuleRestClient authModuleRestClient;
    protected final IModel<List<String>> allAuthModules = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = -2012833443695917883L;

        protected List<String> load() {
            return AuthPolicyModalPanel.this.authModuleRestClient.list().stream().map(AuthModuleTO::getKey).sorted().collect(Collectors.toList());
        }
    };
    private final IModel<AuthPolicyTO> model;

    public AuthPolicyModalPanel(BaseModal<AuthPolicyTO> modal, IModel<AuthPolicyTO> model, PageReference pageRef) {
        super(modal, pageRef);
        this.model = model;
        this.add(new Component[]{new AjaxCheckBoxPanel("tryAll", "tryAll", (IModel)new PropertyModel((Object)((AuthPolicyTO)model.getObject()).getConf(), "tryAll"), false)});
        this.add(new Component[]{new AjaxPalettePanel.Builder().setName("authModules").build("authModules", (IModel)new PropertyModel((Object)((AuthPolicyTO)model.getObject()).getConf(), "authModules"), this.allAuthModules)});
        this.add(new Component[]{new AjaxCheckBoxPanel("bypassEnabled", "bypassEnabled", (IModel)new PropertyModel((Object)((AuthPolicyTO)model.getObject()).getConf(), "bypassEnabled"), false)});
        this.add(new Component[]{new AjaxCheckBoxPanel("forceMfaExecution", "forceMfaExecution", (IModel)new PropertyModel((Object)((AuthPolicyTO)model.getObject()).getConf(), "forceMfaExecution"), false)});
        this.add(new Component[]{new AjaxTextFieldPanel("bypassPrincipalAttributeName", "bypassPrincipalAttributeName", (IModel)new PropertyModel((Object)((AuthPolicyTO)model.getObject()).getConf(), "bypassPrincipalAttributeName"), false)});
        this.add(new Component[]{new AjaxTextFieldPanel("bypassPrincipalAttributeValue", "bypassPrincipalAttributeValue", (IModel)new PropertyModel((Object)((AuthPolicyTO)model.getObject()).getConf(), "bypassPrincipalAttributeValue"), false)});
        this.add(new Component[]{new AjaxCheckBoxPanel("bypassTrustedDeviceEnabled", "bypassTrustedDeviceEnabled", (IModel)new PropertyModel((Object)((AuthPolicyTO)model.getObject()).getConf(), "bypassTrustedDeviceEnabled"), false)});
    }

    public void onSubmit(AjaxRequestTarget target) {
        try {
            this.policyRestClient.update(PolicyType.AUTH, (PolicyTO)((AuthPolicyTO)this.model.getObject()));
            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
            this.modal.close((IPartialPageRequestHandler)target);
        }
        catch (Exception e) {
            LOG.error("While updating Auth Policy {}", (Object)((AuthPolicyTO)this.model.getObject()).getKey(), (Object)e);
            SyncopeConsoleSession.get().onException(e);
        }
        ((BaseWebPage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
    }
}

