/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.metadata;

import com.github.javaparser.ast.type.ClassOrInterfaceType;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigurationMetadataClassSourceLocator {
    private static final Pattern GENERIC_TYPED_CLASS = Pattern.compile("\\w+<(\\w+)>");
    private static ConfigurationMetadataClassSourceLocator INSTANCE;
    private final Map<String, Class> cachedPropertiesClasses = new HashMap<String, Class>();

    public static ConfigurationMetadataClassSourceLocator getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ConfigurationMetadataClassSourceLocator();
        }
        return INSTANCE;
    }

    public static String buildTypeSourcePath(String sourcePath, String type) {
        String newName = type.replace(".", File.separator);
        return sourcePath + "/src/main/java/" + newName + ".java";
    }

    public Class locatePropertiesClassForType(ClassOrInterfaceType type) {
        String typeName = type.getNameAsString();
        if (this.cachedPropertiesClasses.containsKey(typeName)) {
            return this.cachedPropertiesClasses.get(typeName);
        }
        Matcher matcher = GENERIC_TYPED_CLASS.matcher(type.toString());
        if (matcher.matches()) {
            typeName = matcher.group(1);
        }
        IllegalArgumentException error = new IllegalArgumentException("Can't locate class for " + typeName);
        Class<?> clz = ConfigurationMetadataClassSourceLocator.findClassBySimpleNameInPackage(typeName, "org.apereo.cas").orElseThrow(() -> error);
        this.cachedPropertiesClasses.put(typeName, clz);
        return clz;
    }

    static Optional<Class<?>> findClassBySimpleNameInPackage(String simpleName, String ... packageName) {
        try (ScanResult scanResult = new ClassGraph().acceptPackages(packageName).enableClassInfo().scan();){
            Optional<Class<?>> optional = scanResult.getAllClasses().stream().filter(classInfo -> classInfo.getSimpleName().equalsIgnoreCase(simpleName)).findFirst().map(ClassInfo::loadClass);
            return optional;
        }
    }
}

