/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.support;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import lombok.Generated;
import org.apache.commons.lang3.Strings;

public enum TriStateBoolean {
    TRUE(Boolean.TRUE),
    FALSE(Boolean.FALSE),
    UNDEFINED(null);

    private static final long serialVersionUID = -145819796564884951L;
    private final Boolean state;

    public static TriStateBoolean fromBoolean(boolean value) {
        return value ? TRUE : FALSE;
    }

    public boolean isTrue() {
        return Boolean.TRUE.equals(this.state);
    }

    public boolean isFalse() {
        return Boolean.FALSE.equals(this.state);
    }

    public boolean isUndefined() {
        return this.state == null;
    }

    public Boolean toBoolean() {
        return this.state;
    }

    @Generated
    private TriStateBoolean(Boolean state) {
        this.state = state;
    }

    public static class Deserializer
    extends JsonDeserializer<TriStateBoolean> {
        public TriStateBoolean deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            String value = jsonParser.getText();
            if (Strings.CI.equals(value, Boolean.TRUE.toString())) {
                return TRUE;
            }
            if (Strings.CI.equals(value, Boolean.FALSE.toString())) {
                return FALSE;
            }
            return TriStateBoolean.valueOf(value);
        }

        @Generated
        public Deserializer() {
        }
    }
}

