/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions.composite;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderSelectionCookieProperties;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.CookieUtils;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class MultifactorProviderSelectedAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorProviderSelectedAction.class);
    static final String PARAMETER_SELECTED_MFA_PROVIDER = "mfaProvider";
    private final CasCookieBuilder multifactorProviderCookieBuilder;
    private final CasConfigurationProperties casProperties;

    protected Event doPreExecute(RequestContext context) throws Exception {
        MultifactorAuthenticationProviderSelectionCookieProperties cookie = this.casProperties.getAuthn().getMfa().getCore().getProviderSelection().getCookie();
        if (cookie.isEnabled() && cookie.isAutoConfigureCookiePath()) {
            CookieUtils.configureCookiePath((RequestContext)context, (CasCookieBuilder)this.multifactorProviderCookieBuilder);
        }
        return super.doPreExecute(context);
    }

    protected Event doExecuteInternal(RequestContext requestContext) {
        boolean mfaOptional = this.casProperties.getAuthn().getMfa().getCore().getProviderSelection().isProviderSelectionOptional();
        String selectedProvider = WebUtils.getRequestParameterOrAttribute((RequestContext)requestContext, (String)PARAMETER_SELECTED_MFA_PROVIDER).orElseGet(() -> ((MultifactorAuthenticationProvider)requestContext.getFlashScope().get(PARAMETER_SELECTED_MFA_PROVIDER, MultifactorAuthenticationProvider.class)).getId());
        if (mfaOptional && Strings.CI.equals(selectedProvider, "none")) {
            LOGGER.debug("No multifactor authentication provider is selected, and provider selection is optional. Proceeding with authentication without MFA");
            return this.eventFactory.event((Object)this, "skip");
        }
        LOGGER.debug("Selected multifactor authentication provider is [{}]", (Object)selectedProvider);
        this.rememberSelectedMultifactorAuthenticationProvider(requestContext, selectedProvider);
        return this.eventFactory.event((Object)this, selectedProvider);
    }

    protected void rememberSelectedMultifactorAuthenticationProvider(RequestContext requestContext, String selectedProvider) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        this.multifactorProviderCookieBuilder.addCookie(request, response, selectedProvider);
    }

    @Generated
    public MultifactorProviderSelectedAction(CasCookieBuilder multifactorProviderCookieBuilder, CasConfigurationProperties casProperties) {
        this.multifactorProviderCookieBuilder = multifactorProviderCookieBuilder;
        this.casProperties = casProperties;
    }

    @Generated
    public CasCookieBuilder getMultifactorProviderCookieBuilder() {
        return this.multifactorProviderCookieBuilder;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }
}

