/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.context;

import java.util.UUID;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.log.LogAccessor;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.context.ComponentSourceAware;
import org.springframework.integration.context.ExpressionCapable;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.integration.context.IntegrationProperties;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.channel.ChannelResolverUtils;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.AlternativeJdkIdGenerator;
import org.springframework.util.Assert;
import org.springframework.util.IdGenerator;
import org.springframework.util.StringUtils;

public abstract class IntegrationObjectSupport
implements ComponentSourceAware,
NamedComponent,
ApplicationContextAware,
BeanFactoryAware,
InitializingBean,
ExpressionCapable {
    protected static final ExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    private static final IdGenerator ID_GENERATOR = new AlternativeJdkIdGenerator();
    protected final LogAccessor logger = new LogAccessor(this.getClass());
    private DestinationResolver<MessageChannel> channelResolver;
    private String beanName;
    private String componentName;
    private BeanFactory beanFactory;
    private TaskScheduler taskScheduler;
    private IntegrationProperties integrationProperties = new IntegrationProperties();
    private ConversionService conversionService;
    private ApplicationContext applicationContext;
    private MessageBuilderFactory messageBuilderFactory;
    private Expression expression;
    private Object beanSource;
    private String beanDescription;
    private boolean initialized;

    public final void setBeanName(@Nullable String beanName) {
        this.beanName = beanName;
    }

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    @Override
    public String getComponentName() {
        return StringUtils.hasText((String)this.componentName) ? this.componentName : this.beanName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    @Override
    public String getComponentType() {
        return null;
    }

    @Override
    public void setComponentSource(Object source) {
        this.beanSource = source;
    }

    @Override
    @Nullable
    public Object getComponentSource() {
        return this.beanSource;
    }

    @Override
    public void setComponentDescription(String description) {
        this.beanDescription = description;
    }

    @Override
    @Nullable
    public String getComponentDescription() {
        return this.beanDescription;
    }

    public String getBeanDescription() {
        StringBuilder sb = new StringBuilder("bean '").append(this.beanName).append("'");
        String beanComponentName = this.getComponentName();
        if (!this.beanName.equals(beanComponentName)) {
            sb.append(" for component '").append(beanComponentName).append("'");
        }
        if (this.beanDescription != null) {
            sb.append("; defined in: '").append(this.beanDescription).append("'");
        }
        if (this.beanSource != null) {
            sb.append("; from source: '").append(this.beanSource).append("'");
        }
        return sb.toString();
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"'beanFactory' must not be null");
        this.beanFactory = beanFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Assert.notNull((Object)applicationContext, (String)"'applicationContext' must not be null");
        this.applicationContext = applicationContext;
    }

    public void setChannelResolver(DestinationResolver<MessageChannel> channelResolver) {
        Assert.notNull(channelResolver, (String)"'channelResolver' must not be null");
        this.channelResolver = channelResolver;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    public final void setPrimaryExpression(Expression expression) {
        this.expression = expression;
    }

    public final void afterPropertiesSet() {
        ConfigurableListableBeanFactory configurableListableBeanFactory;
        BeanFactory beanFactory;
        this.integrationProperties = IntegrationContextUtils.getIntegrationProperties(this.beanFactory);
        if (this.messageBuilderFactory == null) {
            this.messageBuilderFactory = this.beanFactory != null ? IntegrationUtils.getMessageBuilderFactory(this.beanFactory) : new DefaultMessageBuilderFactory();
        }
        if (this.beanSource == null && this.beanName != null && (beanFactory = this.beanFactory) instanceof ConfigurableListableBeanFactory && (configurableListableBeanFactory = (ConfigurableListableBeanFactory)beanFactory).containsBeanDefinition(this.beanName)) {
            BeanDefinition beanDefinition = configurableListableBeanFactory.getBeanDefinition(this.beanName);
            this.beanSource = beanDefinition.getSource();
            if (this.beanDescription == null) {
                this.beanDescription = beanDefinition.getResourceDescription();
            }
        }
        this.onInit();
        this.initialized = true;
    }

    protected void onInit() {
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setTaskScheduler(TaskScheduler taskScheduler) {
        Assert.notNull((Object)taskScheduler, (String)"taskScheduler must not be null");
        this.taskScheduler = taskScheduler;
    }

    protected TaskScheduler getTaskScheduler() {
        if (this.taskScheduler == null && this.beanFactory != null) {
            this.taskScheduler = IntegrationContextUtils.getTaskScheduler(this.beanFactory);
        }
        return this.taskScheduler;
    }

    protected DestinationResolver<MessageChannel> getChannelResolver() {
        if (this.channelResolver == null) {
            this.channelResolver = ChannelResolverUtils.getChannelResolver(this.beanFactory);
        }
        return this.channelResolver;
    }

    public ConversionService getConversionService() {
        if (this.conversionService == null && this.beanFactory != null) {
            this.conversionService = IntegrationUtils.getConversionService(this.beanFactory);
            if (this.conversionService == null) {
                this.logger.debug(() -> "Unable to attempt conversion of Message payload types. Component '" + this.getComponentName() + "' has no explicit ConversionService reference, and there is no 'integrationConversionService' bean within the context.");
            }
        }
        return this.conversionService;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public String getApplicationContextId() {
        return this.applicationContext == null ? null : this.applicationContext.getId();
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected IntegrationProperties getIntegrationProperties() {
        return this.integrationProperties;
    }

    protected MessageBuilderFactory getMessageBuilderFactory() {
        if (this.messageBuilderFactory == null) {
            this.messageBuilderFactory = new DefaultMessageBuilderFactory();
        }
        return this.messageBuilderFactory;
    }

    public void setMessageBuilderFactory(MessageBuilderFactory messageBuilderFactory) {
        this.messageBuilderFactory = messageBuilderFactory;
    }

    public String toString() {
        return this.beanName != null ? this.getBeanDescription() : super.toString();
    }

    @Nullable
    public static <T> T extractTypeIfPossible(@Nullable Object targetObject, Class<T> expectedType) {
        if (targetObject == null) {
            return null;
        }
        if (expectedType.isAssignableFrom(targetObject.getClass())) {
            return (T)targetObject;
        }
        return IntegrationObjectSupport.extractTypeIfPossible(AopProxyUtils.getSingletonTarget((Object)targetObject), expectedType);
    }

    public static UUID generateId() {
        return ID_GENERATOR.generateId();
    }
}

