/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.MethodClassKey;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationConfigurationException;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.RepeatableContainers;
import org.springframework.security.core.annotation.AbstractSecurityAnnotationScanner;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

final class UniqueSecurityAnnotationScanner<A extends Annotation>
extends AbstractSecurityAnnotationScanner<A> {
    private final List<Class<A>> types;
    private final Map<Parameter, MergedAnnotation<A>> uniqueParameterAnnotationCache = new ConcurrentHashMap<Parameter, MergedAnnotation<A>>();
    private final Map<MethodClassKey, MergedAnnotation<A>> uniqueMethodAnnotationCache = new ConcurrentHashMap<MethodClassKey, MergedAnnotation<A>>();

    UniqueSecurityAnnotationScanner(Class<A> type) {
        Assert.notNull(type, (String)"type cannot be null");
        this.types = List.of(type);
    }

    UniqueSecurityAnnotationScanner(List<Class<A>> types) {
        Assert.notNull(types, (String)"types cannot be null");
        this.types = types;
    }

    @Override
    MergedAnnotation<A> merge(AnnotatedElement element, Class<?> targetClass) {
        if (element instanceof Parameter) {
            Parameter parameter = (Parameter)element;
            return this.uniqueParameterAnnotationCache.computeIfAbsent(parameter, p -> {
                List<MergedAnnotation<A>> annotations = this.findParameterAnnotations((Parameter)p);
                return this.requireUnique((AnnotatedElement)p, annotations);
            });
        }
        if (element instanceof Method) {
            Method method = (Method)element;
            return this.uniqueMethodAnnotationCache.computeIfAbsent(new MethodClassKey(method, targetClass), k -> {
                List<MergedAnnotation<A>> annotations = this.findMethodAnnotations(method, targetClass);
                return this.requireUnique(method, annotations);
            });
        }
        throw new AnnotationConfigurationException("Unsupported element of type " + String.valueOf(element.getClass()));
    }

    private MergedAnnotation<A> requireUnique(AnnotatedElement element, List<MergedAnnotation<A>> annotations) {
        return switch (annotations.size()) {
            case 0 -> null;
            case 1 -> annotations.get(0);
            default -> {
                ArrayList<Annotation> synthesized = new ArrayList<Annotation>();
                for (MergedAnnotation<A> annotation : annotations) {
                    synthesized.add(annotation.synthesize());
                }
                throw new AnnotationConfigurationException("Please ensure there is one unique annotation of type %s attributed to %s. Found %d competing annotations: %s".formatted(this.types, element, annotations.size(), synthesized));
            }
        };
    }

    private List<MergedAnnotation<A>> findParameterAnnotations(Parameter current) {
        Method method;
        List<MergedAnnotation<A>> directAnnotations = this.findDirectAnnotations(current);
        if (!directAnnotations.isEmpty()) {
            return directAnnotations;
        }
        Executable executable = current.getDeclaringExecutable();
        if (executable instanceof Method && !(directAnnotations = this.findClosestParameterAnnotations(method = (Method)executable, method.getDeclaringClass(), current, new HashSet())).isEmpty()) {
            return directAnnotations;
        }
        return Collections.emptyList();
    }

    private List<MergedAnnotation<A>> findClosestParameterAnnotations(Method method, Class<?> clazz, Parameter current, Set<Class<?>> visited) {
        if (clazz == null || clazz == Object.class || !visited.add(clazz)) {
            return Collections.emptyList();
        }
        List<MergedAnnotation<A>> directAnnotations = this.findDirectParameterAnnotations(method, clazz, current);
        if (!directAnnotations.isEmpty()) {
            return directAnnotations;
        }
        ArrayList<MergedAnnotation<A>> annotations = new ArrayList<MergedAnnotation<A>>(this.findClosestParameterAnnotations(method, clazz.getSuperclass(), current, visited));
        for (Class<?> ifc : clazz.getInterfaces()) {
            annotations.addAll(this.findClosestParameterAnnotations(method, ifc, current, visited));
        }
        return annotations;
    }

    private List<MergedAnnotation<A>> findDirectParameterAnnotations(Method method, Class<?> clazz, Parameter current) {
        try {
            Method methodToUse = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
            for (Parameter parameter : methodToUse.getParameters()) {
                List<MergedAnnotation<A>> directAnnotations;
                if (!parameter.getName().equals(current.getName()) || (directAnnotations = this.findDirectAnnotations(parameter)).isEmpty()) continue;
                return directAnnotations;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private List<MergedAnnotation<A>> findMethodAnnotations(Method method, Class<?> targetClass) {
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, targetClass);
        List<MergedAnnotation<A>> annotations = this.findClosestMethodAnnotations(specificMethod, specificMethod.getDeclaringClass(), new HashSet());
        if (!annotations.isEmpty()) {
            return annotations;
        }
        if (specificMethod != method && !(annotations = this.findClosestMethodAnnotations(method, method.getDeclaringClass(), new HashSet())).isEmpty()) {
            return annotations;
        }
        annotations = this.findClosestClassAnnotations(specificMethod.getDeclaringClass(), new HashSet());
        if (!annotations.isEmpty()) {
            return annotations;
        }
        return Collections.emptyList();
    }

    private List<MergedAnnotation<A>> findClosestMethodAnnotations(Method method, Class<?> targetClass, Set<Class<?>> classesToSkip) {
        List<MergedAnnotation<A>> annotations;
        if (targetClass == null || classesToSkip.contains(targetClass) || targetClass == Object.class) {
            return Collections.emptyList();
        }
        classesToSkip.add(targetClass);
        Method methodToUse = UniqueSecurityAnnotationScanner.findMethod(method, targetClass);
        if (methodToUse != null && !(annotations = this.findDirectAnnotations(methodToUse)).isEmpty()) {
            return annotations;
        }
        annotations = new ArrayList<MergedAnnotation<A>>(this.findClosestMethodAnnotations(method, targetClass.getSuperclass(), classesToSkip));
        for (Class<?> inter : targetClass.getInterfaces()) {
            annotations.addAll(this.findClosestMethodAnnotations(method, inter, classesToSkip));
        }
        return annotations;
    }

    private List<MergedAnnotation<A>> findClosestClassAnnotations(Class<?> targetClass, Set<Class<?>> classesToSkip) {
        if (targetClass == null || classesToSkip.contains(targetClass) || targetClass == Object.class) {
            return Collections.emptyList();
        }
        classesToSkip.add(targetClass);
        ArrayList<MergedAnnotation<A>> annotations = new ArrayList<MergedAnnotation<A>>(this.findDirectAnnotations(targetClass));
        if (!annotations.isEmpty()) {
            return annotations;
        }
        annotations.addAll(this.findClosestClassAnnotations(targetClass.getSuperclass(), classesToSkip));
        for (Class<?> inter : targetClass.getInterfaces()) {
            annotations.addAll(this.findClosestClassAnnotations(inter, classesToSkip));
        }
        return annotations;
    }

    private List<MergedAnnotation<A>> findDirectAnnotations(AnnotatedElement element) {
        MergedAnnotations mergedAnnotations = MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.DIRECT, (RepeatableContainers)RepeatableContainers.none());
        return mergedAnnotations.stream().filter(annotation -> this.types.contains(annotation.getType())).map(annotation -> annotation).toList();
    }

    private static Method findMethod(Method method, Class<?> targetClass) {
        for (Method candidate : targetClass.getDeclaredMethods()) {
            if (candidate.equals(method)) {
                return candidate;
            }
            if (!UniqueSecurityAnnotationScanner.isOverride(method, candidate)) continue;
            return candidate;
        }
        return null;
    }

    private static boolean isOverride(Method rootMethod, Method candidateMethod) {
        return !Modifier.isPrivate(candidateMethod.getModifiers()) && candidateMethod.getName().equals(rootMethod.getName()) && UniqueSecurityAnnotationScanner.hasSameParameterTypes(rootMethod, candidateMethod);
    }

    private static boolean hasSameParameterTypes(Method rootMethod, Method candidateMethod) {
        if (candidateMethod.getParameterCount() != rootMethod.getParameterCount()) {
            return false;
        }
        Object[] rootParameterTypes = rootMethod.getParameterTypes();
        Object[] candidateParameterTypes = candidateMethod.getParameterTypes();
        if (Arrays.equals(candidateParameterTypes, rootParameterTypes)) {
            return true;
        }
        return UniqueSecurityAnnotationScanner.hasSameGenericTypeParameters(rootMethod, candidateMethod, rootParameterTypes);
    }

    private static boolean hasSameGenericTypeParameters(Method rootMethod, Method candidateMethod, Class<?>[] rootParameterTypes) {
        Class<?> sourceDeclaringClass = rootMethod.getDeclaringClass();
        Class<?> candidateDeclaringClass = candidateMethod.getDeclaringClass();
        if (!candidateDeclaringClass.isAssignableFrom(sourceDeclaringClass)) {
            return false;
        }
        for (int i = 0; i < rootParameterTypes.length; ++i) {
            Class resolvedParameterType = ResolvableType.forMethodParameter((Method)candidateMethod, (int)i, sourceDeclaringClass).toClass();
            if (rootParameterTypes[i] == resolvedParameterType) continue;
            return false;
        }
        return true;
    }
}

