/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.event.hook;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.event.hook.EventHook;
import com.okta.sdk.resource.event.hook.EventHookChannel;
import com.okta.sdk.resource.event.hook.EventSubscriptions;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultEventHook
extends AbstractInstanceResource<EventHook>
implements EventHook {
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final ResourceReference<EventHookChannel> channelProperty = new ResourceReference<EventHookChannel>("channel", EventHookChannel.class, false);
    private static final DateProperty createdProperty = new DateProperty("created");
    private static final StringProperty createdByProperty = new StringProperty("createdBy");
    private static final ResourceReference<EventSubscriptions> eventsProperty = new ResourceReference<EventSubscriptions>("events", EventSubscriptions.class, false);
    private static final StringProperty idProperty = new StringProperty("id");
    private static final DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private static final StringProperty nameProperty = new StringProperty("name");
    private static final EnumProperty<EventHook.StatusEnum> statusProperty = new EnumProperty<EventHook.StatusEnum>("status", EventHook.StatusEnum.class);
    private static final EnumProperty<EventHook.VerificationStatusEnum> verificationStatusProperty = new EnumProperty<EventHook.VerificationStatusEnum>("verificationStatus", EventHook.VerificationStatusEnum.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultEventHook.createPropertyDescriptorMap(linksProperty, channelProperty, createdProperty, createdByProperty, eventsProperty, idProperty, lastUpdatedProperty, nameProperty, statusProperty, verificationStatusProperty);

    public DefaultEventHook(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultEventHook(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return EventHook.class;
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public EventHookChannel getChannel() {
        return this.getResourceProperty(channelProperty);
    }

    public EventHook setChannel(EventHookChannel channel) {
        this.setProperty(channelProperty, (Object)channel);
        return this;
    }

    public Date getCreated() {
        return this.getDateProperty(createdProperty);
    }

    public String getCreatedBy() {
        return this.getString(createdByProperty);
    }

    public EventHook setCreatedBy(String createdBy) {
        this.setProperty(createdByProperty, (Object)createdBy);
        return this;
    }

    public EventSubscriptions getEvents() {
        return this.getResourceProperty(eventsProperty);
    }

    public EventHook setEvents(EventSubscriptions events) {
        this.setProperty(eventsProperty, (Object)events);
        return this;
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public Date getLastUpdated() {
        return this.getDateProperty(lastUpdatedProperty);
    }

    public String getName() {
        return this.getString(nameProperty);
    }

    public EventHook setName(String name) {
        this.setProperty(nameProperty, (Object)name);
        return this;
    }

    public EventHook.StatusEnum getStatus() {
        return this.getEnumProperty(statusProperty);
    }

    public EventHook setStatus(EventHook.StatusEnum status) {
        this.setProperty(statusProperty, (Object)status);
        return this;
    }

    public EventHook.VerificationStatusEnum getVerificationStatus() {
        return this.getEnumProperty(verificationStatusProperty);
    }

    public EventHook setVerificationStatus(EventHook.VerificationStatusEnum verificationStatus) {
        this.setProperty(verificationStatusProperty, (Object)verificationStatus);
        return this;
    }

    public EventHook update() {
        String eventHookId = this.getId();
        Assert.hasText((String)eventHookId, (String)"'eventHookId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/eventHooks/" + eventHookId + "";
        this.getDataStore().save(href, this, null, queryArgs, (Map<String, List<String>>)headers);
        return this;
    }

    public EventHook deactivate() {
        String eventHookId = this.getId();
        Assert.hasText((String)eventHookId, (String)"'eventHookId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/eventHooks/" + eventHookId + "/lifecycle/deactivate", new DefaultVoidResource(this.getDataStore()), this, EventHook.class, queryArgs, (Map<String, List<String>>)headers);
    }

    @Override
    public void delete() {
        String eventHookId = this.getId();
        Assert.hasText((String)eventHookId, (String)"'eventHookId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/eventHooks/" + eventHookId + "", this, queryArgs, (Map<String, List<String>>)headers);
    }

    public EventHook activate() {
        String eventHookId = this.getId();
        Assert.hasText((String)eventHookId, (String)"'eventHookId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/eventHooks/" + eventHookId + "/lifecycle/activate", new DefaultVoidResource(this.getDataStore()), this, EventHook.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public EventHook verify() {
        String eventHookId = this.getId();
        Assert.hasText((String)eventHookId, (String)"'eventHookId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/eventHooks/" + eventHookId + "/lifecycle/verify", new DefaultVoidResource(this.getDataStore()), this, EventHook.class, queryArgs, (Map<String, List<String>>)headers);
    }
}

