/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.assurance;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.oidc.assurance.AssuranceVerificationSource;
import org.apereo.cas.oidc.assurance.AssuranceVerifiedClaimsProducer;
import org.apereo.cas.oidc.assurance.entity.Evidence;
import org.apereo.cas.oidc.assurance.entity.Verification;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.jooq.lambda.Unchecked;
import org.jose4j.jwt.JwtClaims;

public class DefaultAssuranceVerifiedClaimsProducer
implements AssuranceVerifiedClaimsProducer {
    static final String CLAIM_NAME_VERIFIED_CLAIMS = "verified_claims";
    static final String CLAIM_NAME_CLAIMS = "claims";
    protected final AssuranceVerificationSource assuranceVerificationSource;
    protected final OidcServerDiscoverySettings discoverySettings;

    @Override
    public Map<String, Object> produce(JwtClaims jwtClaims, String claimName, String trustFramework) {
        if (!this.discoverySettings.isVerifiedClaimsSupported() || this.discoverySettings.getTrustFrameworksSupported() != null && !this.discoverySettings.getTrustFrameworksSupported().contains(trustFramework)) {
            return Map.of();
        }
        Optional<Verification> source = this.assuranceVerificationSource.findByTrustFramework(trustFramework);
        return source.map(Unchecked.function(verification -> {
            List<Evidence> evidenceList = verification.getEvidence();
            if (evidenceList != null) {
                evidenceList.removeIf(evidence -> this.discoverySettings.getEvidenceSupported() != null && !this.discoverySettings.getEvidenceSupported().contains(evidence.getType()));
                evidenceList.removeIf(evidence -> this.discoverySettings.getDocumentsSupported() != null && !this.discoverySettings.getDocumentsSupported().contains(evidence.getDocument().getType()));
                evidenceList.removeIf(evidence -> this.discoverySettings.getDocumentsSupported() != null && !this.discoverySettings.getDocumentsSupported().contains(evidence.getDocumentDetails().getType()));
                evidenceList.removeIf(evidence -> this.discoverySettings.getDocumentsValidationMethodsSupported() != null && !this.discoverySettings.getDocumentsValidationMethodsSupported().contains(evidence.getValidationMethod().getType()));
                evidenceList.removeIf(evidence -> this.discoverySettings.getDocumentsVerificationMethodsSupported() != null && !this.discoverySettings.getDocumentsVerificationMethodsSupported().contains(evidence.getVerificationMethod().getType()));
                evidenceList.removeIf(evidence -> this.discoverySettings.getElectronicRecordsSupported() != null && !this.discoverySettings.getElectronicRecordsSupported().contains(evidence.getRecord().getType()));
            }
            Map finalVerification = JwtClaims.parse((String)verification.toJson()).getClaimsMap();
            Map verifiedClaims = (Map)Objects.requireNonNullElseGet(jwtClaims.getClaimValue(CLAIM_NAME_VERIFIED_CLAIMS), HashMap::new);
            verifiedClaims.put("verification", finalVerification);
            Object currentClaimValue = jwtClaims.getClaimValue(claimName);
            Map claims = (Map)Objects.requireNonNullElseGet(verifiedClaims.get(CLAIM_NAME_CLAIMS), HashMap::new);
            if (this.discoverySettings.getClaimsInVerifiedClaimsSupported() == null || this.discoverySettings.getClaimsInVerifiedClaimsSupported().contains(claimName)) {
                claims.put(claimName, currentClaimValue);
                jwtClaims.unsetClaim(claimName);
            }
            verifiedClaims.put(CLAIM_NAME_CLAIMS, claims);
            jwtClaims.setClaim(CLAIM_NAME_VERIFIED_CLAIMS, (Object)verifiedClaims);
            return jwtClaims.getClaimsMap();
        })).orElseGet(Map::of);
    }

    @Generated
    public DefaultAssuranceVerifiedClaimsProducer(AssuranceVerificationSource assuranceVerificationSource, OidcServerDiscoverySettings discoverySettings) {
        this.assuranceVerificationSource = assuranceVerificationSource;
        this.discoverySettings = discoverySettings;
    }
}

