/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.federation;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityType;
import com.nimbusds.openid.connect.sdk.federation.policy.MetadataPolicy;
import com.nimbusds.openid.connect.sdk.federation.trust.TrustChain;
import com.nimbusds.openid.connect.sdk.federation.trust.TrustChainResolver;
import com.nimbusds.openid.connect.sdk.federation.trust.TrustChainSet;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.oidc.federation.OidcFederationTrustChainResolver;
import org.apereo.cas.services.DefaultRegisteredServiceContact;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.util.function.FunctionUtils;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcFederationDefaultTrustChainResolver
implements OidcFederationTrustChainResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcFederationDefaultTrustChainResolver.class);
    private final List<TrustChainResolver> trustChainResolvers;

    @Override
    public Optional<OidcRegisteredService> resolveTrustChains(String id) throws Exception {
        if (Strings.CI.startsWith((CharSequence)id, (CharSequence)"http")) {
            EntityID entityId = new EntityID(id);
            for (TrustChainResolver trustChainResolver : this.trustChainResolvers) {
                Optional<OIDCClientMetadata> rpMetadataResult = this.fetchRelyingPartyMetadata(trustChainResolver, entityId);
                if (!rpMetadataResult.isPresent()) continue;
                OIDCClientMetadata rpMetadata = rpMetadataResult.get();
                OidcRegisteredService oidcRegisteredService = this.extractRegisteredService(entityId, rpMetadata);
                return Optional.ofNullable(oidcRegisteredService);
            }
        }
        return Optional.empty();
    }

    protected OidcRegisteredService extractRegisteredService(EntityID entityId, OIDCClientMetadata rpMetadata) throws Exception {
        OidcRegisteredService registeredService = new OidcRegisteredService();
        registeredService.assignIdIfNecessary();
        registeredService.setTlsClientAuthSanDns(rpMetadata.getTLSClientAuthSanDNS());
        registeredService.setTlsClientAuthSanEmail(rpMetadata.getTLSClientAuthSanEmail());
        registeredService.setTlsClientAuthSanIp(rpMetadata.getTLSClientAuthSanIP());
        registeredService.setTlsClientAuthSanUri(rpMetadata.getTLSClientAuthSanURI());
        registeredService.setTlsClientAuthSubjectDn(rpMetadata.getTLSClientAuthSubjectDN());
        registeredService.setName(rpMetadata.getName());
        registeredService.setDescription(rpMetadata.getOrganizationName());
        registeredService.setClientId(entityId.toClientID().getValue());
        registeredService.setScopes(new HashSet(rpMetadata.getScope().toStringList()));
        registeredService.setApplicationType(rpMetadata.getApplicationType().toString());
        registeredService.setSubjectType(rpMetadata.getSubjectType().toString());
        FunctionUtils.doIfNotNull((Object)rpMetadata.getSectorIDURI(), value -> registeredService.setSectorIdentifierUri(value.toASCIIString()));
        FunctionUtils.doIfNotNull((Object)rpMetadata.getIDTokenJWSAlg(), value -> registeredService.setIdTokenSigningAlg(value.getName()));
        FunctionUtils.doIfNotNull((Object)rpMetadata.getIDTokenJWEAlg(), value -> registeredService.setIdTokenEncryptionAlg(value.getName()));
        FunctionUtils.doIfNotNull((Object)rpMetadata.getIDTokenJWEEnc(), value -> registeredService.setIdTokenEncryptionEncoding(value.getName()));
        FunctionUtils.doIfNotNull((Object)rpMetadata.getUserInfoJWSAlg(), value -> registeredService.setUserInfoSigningAlg(value.getName()));
        FunctionUtils.doIfNotNull((Object)rpMetadata.getUserInfoJWEAlg(), value -> registeredService.setUserInfoEncryptedResponseAlg(value.getName()));
        FunctionUtils.doIfNotNull((Object)rpMetadata.getUserInfoJWEEnc(), value -> registeredService.setUserInfoEncryptedResponseEncoding(value.getName()));
        if (rpMetadata.getEmailContacts() != null) {
            List contacts = rpMetadata.getEmailContacts().stream().map(email -> new DefaultRegisteredServiceContact().setEmail(email)).collect(Collectors.toList());
            registeredService.setContacts(contacts);
        }
        if (rpMetadata.getRedirectionURIStrings() != null) {
            String redirectUris = String.join((CharSequence)"|", rpMetadata.getRedirectionURIStrings());
            registeredService.setServiceId(redirectUris);
        }
        FunctionUtils.doIfNotNull((Object)rpMetadata.getLogoURI(), value -> registeredService.setLogo(value.toURL().toExternalForm()));
        FunctionUtils.doIfNotNull((Object)rpMetadata.getPolicyURI(), value -> registeredService.setPrivacyUrl(value.toURL().toExternalForm()));
        FunctionUtils.doIfNotNull((Object)rpMetadata.getTermsOfServiceURI(), value -> registeredService.setInformationUrl(value.toURL().toExternalForm()));
        if (rpMetadata.getGrantTypes() != null) {
            Set grantTypes = rpMetadata.getGrantTypes().stream().map(GrantType::getShortName).collect(Collectors.toSet());
            registeredService.setSupportedGrantTypes(grantTypes);
        }
        if (rpMetadata.getResponseTypes() != null) {
            Set responseTypes = rpMetadata.getResponseTypes().stream().map(ResponseType::toString).collect(Collectors.toSet());
            registeredService.setSupportedResponseTypes(responseTypes);
        }
        if (rpMetadata.getPostLogoutRedirectionURIs() != null) {
            String logoutUrls = rpMetadata.getPostLogoutRedirectionURIs().stream().map(Unchecked.function(url -> url.toURL().toExternalForm())).collect(Collectors.joining(","));
            registeredService.setLogoutUrl(logoutUrls);
        }
        FunctionUtils.doIfNotNull((Object)rpMetadata.getJWKSetURI(), value -> registeredService.setJwks(value.toURL().toExternalForm()));
        FunctionUtils.doIfNotNull((Object)rpMetadata.getTokenEndpointAuthMethod(), method -> registeredService.setTokenEndpointAuthenticationMethod(method.getValue()));
        return registeredService;
    }

    protected Optional<OIDCClientMetadata> fetchRelyingPartyMetadata(TrustChainResolver trustChainResolver, EntityID entityId) {
        return (Optional)FunctionUtils.doAndHandle(() -> {
            TrustChainSet resolvedChains = trustChainResolver.resolveTrustChains(entityId);
            TrustChain chain = resolvedChains.getShortest();
            MetadataPolicy metadataPolicy = chain.resolveCombinedMetadataPolicy(EntityType.OPENID_RELYING_PARTY);
            JWTClaimsSet claims = chain.getLeafConfiguration().getSignedStatement().getJWTClaimsSet();
            JSONObject rawRp = (JSONObject)claims.getClaim(EntityType.OPENID_RELYING_PARTY.getValue());
            JSONObject clientMetadataJson = metadataPolicy.apply(rawRp);
            return Optional.of(OIDCClientMetadata.parse((JSONObject)clientMetadataJson));
        }, e -> Optional.empty()).get();
    }

    @Generated
    public OidcFederationDefaultTrustChainResolver(List<TrustChainResolver> trustChainResolvers) {
        this.trustChainResolvers = trustChainResolvers;
    }
}

