/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.client.direct;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import lombok.Generated;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.credentials.CredentialUtil;
import org.pac4j.http.credentials.extractor.DigestAuthExtractor;

public class DirectDigestAuthClient
extends DirectClient {
    private String realm = "pac4jRealm";

    public DirectDigestAuthClient() {
    }

    public DirectDigestAuthClient(Authenticator digestAuthenticator) {
        this.setAuthenticatorIfUndefined(digestAuthenticator);
    }

    public DirectDigestAuthClient(Authenticator digestAuthenticator, ProfileCreator profileCreator) {
        this.setAuthenticatorIfUndefined(digestAuthenticator);
        this.setProfileCreatorIfUndefined(profileCreator);
    }

    protected void internalInit(boolean forceReinit) {
        this.setCredentialsExtractorIfUndefined(new DigestAuthExtractor());
    }

    protected void checkCredentials(CallContext ctx, Credentials credentials) {
        if (credentials == null) {
            String nonce = this.calculateNonce();
            ctx.webContext().setResponseHeader("WWW-Authenticate", "Digest realm=\"" + this.realm + "\", qop=\"auth\", nonce=\"" + nonce + "\"");
        } else {
            ctx.webContext().setResponseHeader("WWW-Authenticate", null);
        }
    }

    private String calculateNonce() {
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy:MM:dd:HH:mm:ss.SSS");
        String fmtTime = formatter.format(time);
        return CredentialUtil.encryptMD5(fmtTime + CommonHelper.randomString((int)10));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getRealm() {
        return this.realm;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setRealm(String realm) {
        this.realm = realm;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "DirectDigestAuthClient(super=" + super.toString() + ", realm=" + this.realm + ")";
    }
}

