/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.AttributeRepositoryStates;
import org.apereo.cas.persondir.JsonPersonAttributeDao;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlanConfigurer;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.io.FileWatcherService;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.Resource;

@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.PersonDirectory}, module="json")
@Configuration(value="CasPersonDirectoryJsonConfiguration", proxyBeanMethods=false)
class CasPersonDirectoryJsonConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasPersonDirectoryJsonConfiguration.class);
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.attribute-repository.json[0].location").exists();

    CasPersonDirectoryJsonConfiguration() {
    }

    @Configuration(value="JsonAttributeRepositoryPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class JsonAttributeRepositoryPlanConfiguration {
        JsonAttributeRepositoryPlanConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"jsonPersonDirectoryAttributeRepositoryPlanConfigurer"})
        public PersonDirectoryAttributeRepositoryPlanConfigurer jsonPersonDirectoryAttributeRepositoryPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="jsonAttributeRepositories") BeanContainer<PersonAttributeDao> jsonAttributeRepositories) {
            return (PersonDirectoryAttributeRepositoryPlanConfigurer)BeanSupplier.of(PersonDirectoryAttributeRepositoryPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> {
                List results = jsonAttributeRepositories.toList().stream().filter(PersonAttributeDao::isEnabled).collect(Collectors.toList());
                plan.registerAttributeRepositories(results);
            }).otherwiseProxy().get();
        }
    }

    @Configuration(value="JsonAttributeRepositoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class JsonAttributeRepositoryConfiguration {
        JsonAttributeRepositoryConfiguration() {
        }

        @ConditionalOnMissingBean(name={"jsonAttributeRepositories"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BeanContainer<PersonAttributeDao> jsonAttributeRepositories(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (BeanContainer)BeanSupplier.of(BeanContainer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                ArrayList list = new ArrayList();
                casProperties.getAuthn().getAttributeRepository().getJson().stream().filter(json -> ResourceUtils.doesResourceExist((Resource)json.getLocation())).forEach(Unchecked.consumer(json -> {
                    Resource r = json.getLocation();
                    JsonPersonAttributeDao dao = new JsonPersonAttributeDao(r);
                    if (ResourceUtils.isFile((Resource)r)) {
                        FileWatcherService watcherService = new FileWatcherService(r.getFile(), file -> {
                            Thread.sleep(100L);
                            dao.init();
                        });
                        watcherService.start(this.getClass().getSimpleName());
                        dao.setResourceWatcherService((Closeable)watcherService);
                    }
                    dao.setOrder(json.getOrder());
                    FunctionUtils.doIfNotNull((Object)json.getId(), id -> dao.setId(new String[]{id}));
                    dao.setEnabled(json.getState() != AttributeRepositoryStates.DISABLED);
                    dao.putTag("state", (Object)json.getState());
                    dao.init();
                    LOGGER.debug("Configured JSON attribute sources from [{}]", (Object)r);
                    list.add(dao);
                }));
                return BeanContainer.of(list);
            }).otherwise(BeanContainer::empty).get();
        }
    }
}

