/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apereo.cas.authentication.attribute.PersonAttributeUtils;
import org.apereo.cas.authentication.attribute.TenantPersonAttributeDaoBuilder;
import org.apereo.cas.authentication.attribute.TenantStubPersonAttributeDaoBuilder;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.StubPrincipalAttributesProperties;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlanConfigurer;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@Configuration(value="CasPersonDirectoryStubConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.PersonDirectory}, module="stub")
class CasPersonDirectoryStubConfiguration {
    CasPersonDirectoryStubConfiguration() {
    }

    @Configuration(value="StubAttributeRepositoryMultitenancyConfiguration", proxyBeanMethods=false)
    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Multitenancy})
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class StubAttributeRepositoryMultitenancyConfiguration {
        StubAttributeRepositoryMultitenancyConfiguration() {
        }

        @ConditionalOnMissingBean(name={"stubTenantPersonAttributeDaoBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TenantPersonAttributeDaoBuilder stubTenantPersonAttributeDaoBuilder(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (TenantPersonAttributeDaoBuilder)BeanSupplier.of(TenantPersonAttributeDaoBuilder.class).when(BeanCondition.on((String)"cas.multitenancy.core.enabled").isTrue().given((ApplicationContext)applicationContext)).supply(TenantStubPersonAttributeDaoBuilder::new).otherwise(TenantPersonAttributeDaoBuilder::noOp).get();
        }
    }

    @Configuration(value="StubAttributeRepositoryPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class StubAttributeRepositoryPlanConfiguration {
        StubAttributeRepositoryPlanConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"stubPersonDirectoryAttributeRepositoryPlanConfigurer"})
        public PersonDirectoryAttributeRepositoryPlanConfigurer stubPersonDirectoryAttributeRepositoryPlanConfigurer(@Qualifier(value="stubAttributeRepositories") BeanContainer<PersonAttributeDao> stubAttributeRepositories) {
            return plan -> {
                List results = stubAttributeRepositories.toList().stream().filter(PersonAttributeDao::isEnabled).collect(Collectors.toList());
                plan.registerAttributeRepositories(results);
            };
        }
    }

    @Configuration(value="StubAttributeRepositoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class StubAttributeRepositoryConfiguration {
        StubAttributeRepositoryConfiguration() {
        }

        @ConditionalOnMissingBean(name={"stubAttributeRepositories"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BeanContainer<PersonAttributeDao> stubAttributeRepositories(CasConfigurationProperties casProperties) {
            ArrayList<PersonAttributeDao> list = new ArrayList<PersonAttributeDao>();
            StubPrincipalAttributesProperties stub = casProperties.getAuthn().getAttributeRepository().getStub();
            Map attrs = stub.getAttributes();
            if (!attrs.isEmpty()) {
                PersonAttributeDao dao = PersonAttributeUtils.newStubAttributeRepository((StubPrincipalAttributesProperties)casProperties.getAuthn().getAttributeRepository().getStub());
                list.add(dao);
            }
            return BeanContainer.of(list);
        }
    }
}

