/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pac4j.client;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jBaseClientProperties;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.callback.NoParameterCallbackUrlResolver;
import org.pac4j.core.http.callback.PathParameterCallbackUrlResolver;
import org.pac4j.core.http.callback.QueryParameterCallbackUrlResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public interface DelegatedIdentityProviderFactory
extends DisposableBean {
    public static final Logger LOGGER = LoggerFactory.getLogger(DelegatedIdentityProviderFactory.class);
    public static final String BEAN_NAME_SAML2_CLIENT_MESSAGE_FACTORY = "delegatedSaml2ClientSAMLMessageStoreFactory";

    public List<BaseClient> build();

    public void store(String var1, List<BaseClient> var2);

    public List<BaseClient> retrieve(String var1);

    public List<BaseClient> rebuild();

    public List<BaseClient> buildFrom(CasConfigurationProperties var1) throws Exception;

    public static void configureClientName(BaseClient client, String clientName) {
        if (StringUtils.isNotBlank((CharSequence)clientName)) {
            client.setName(clientName);
        } else {
            String className = client.getClass().getSimpleName();
            String genName = className.concat(RandomUtils.randomNumeric((int)4));
            client.setName(genName);
            LOGGER.warn("Client name for [{}] is set to a generated value of [{}]. Consider defining an explicit name for the delegated provider", (Object)className, (Object)genName);
        }
    }

    public static void configureClientCustomProperties(BaseClient client, Pac4jBaseClientProperties clientProperties) {
        Map customProperties = client.getCustomProperties();
        customProperties.put("autoRedirectType", clientProperties.getAutoRedirectType());
        FunctionUtils.doIfNotBlank((CharSequence)clientProperties.getPrincipalIdAttribute(), __ -> customProperties.put("principalAttributeId", clientProperties.getPrincipalIdAttribute()));
        FunctionUtils.doIfNotBlank((CharSequence)clientProperties.getCssClass(), __ -> customProperties.put("cssClass", clientProperties.getCssClass()));
        FunctionUtils.doIfNotBlank((CharSequence)clientProperties.getDisplayName(), __ -> customProperties.put("displayName", clientProperties.getDisplayName()));
    }

    public static void configureClientCallbackUrl(BaseClient client, Pac4jBaseClientProperties clientProperties, String defaultUrl) {
        if (client instanceof IndirectClient) {
            IndirectClient indirectClient = (IndirectClient)client;
            String callbackUrl = (String)StringUtils.defaultIfBlank((CharSequence)clientProperties.getCallbackUrl(), (CharSequence)defaultUrl);
            indirectClient.setCallbackUrl(callbackUrl);
            LOGGER.trace("Client [{}] will use the callback URL [{}]", (Object)client.getName(), (Object)callbackUrl);
            PathParameterCallbackUrlResolver resolver = switch (clientProperties.getCallbackUrlType()) {
                default -> throw new MatchException(null, null);
                case Pac4jBaseClientProperties.CallbackUrlTypes.PATH_PARAMETER -> new PathParameterCallbackUrlResolver();
                case Pac4jBaseClientProperties.CallbackUrlTypes.NONE -> new NoParameterCallbackUrlResolver();
                case Pac4jBaseClientProperties.CallbackUrlTypes.QUERY_PARAMETER -> new QueryParameterCallbackUrlResolver();
            };
            indirectClient.setCallbackUrlResolver((CallbackUrlResolver)resolver);
        }
    }
}

