/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.common.dao.AbstractAnySearchDAO;
import org.apache.syncope.core.persistence.jpa.dao.AbstractJPAAnySearchDAO;
import org.apache.syncope.core.persistence.jpa.dao.AnySearchNode;
import org.apache.syncope.core.persistence.jpa.dao.OrderBySupport;
import org.apache.syncope.core.persistence.jpa.dao.SearchSupport;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.springframework.data.domain.Sort;

public class MySQLJPAAnySearchDAO
extends AbstractJPAAnySearchDAO {
    public MySQLJPAAnySearchDAO(RealmSearchDAO realmSearchDAO, UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, PlainSchemaDAO schemaDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, PlainAttrValidationManager validator, EntityManagerFactory entityManagerFactory, EntityManager entityManager) {
        super(realmSearchDAO, userDAO, groupDAO, anyObjectDAO, schemaDAO, entityFactory, anyUtilsFactory, validator, entityManagerFactory, entityManager);
    }

    @Override
    protected void parseOrderByForPlainSchema(SearchSupport svs, OrderBySupport obs, OrderBySupport.Item item, Sort.Order clause, PlainSchema schema, String fieldName) {
        obs.nonMandatorySchemas = !"true".equals(schema.getMandatoryCondition());
        obs.views.add(svs.field());
        item.select = (schema.isUniqueConstraint() ? "( SELECT JSON_UNQUOTE(JSON_EXTRACT(usa.attrUniqueValue, '$." + MySQLJPAAnySearchDAO.key((AttrSchemaType)schema.getType()) + "')) " : "( SELECT usa." + MySQLJPAAnySearchDAO.key((AttrSchemaType)schema.getType())) + " FROM " + svs.field().name() + " usa WHERE usa.any_id = " + svs.field().alias() + ".any_id" + " AND usa.plainSchema ='" + fieldName + "'" + " LIMIT 1" + ") AS " + fieldName;
        item.where = "plainSchema = '" + fieldName + "'";
        item.orderBy = fieldName + " " + clause.getDirection().name();
    }

    protected AnySearchNode.Leaf filJSONAttrQuery(SearchSupport.SearchView from, PlainAttrValue attrValue, PlainSchema schema, AttrCond cond, boolean not, List<Object> parameters) {
        String key = MySQLJPAAnySearchDAO.key((AttrSchemaType)schema.getType());
        String value = Optional.ofNullable(attrValue.getDateValue()).map(DateTimeFormatter.ISO_OFFSET_DATE_TIME::format).orElseGet(() -> ((AttrCond)cond).getExpression());
        boolean lower = !(schema.getType() != AttrSchemaType.String && schema.getType() != AttrSchemaType.Enum || cond.getType() != AttrCond.Type.IEQ && cond.getType() != AttrCond.Type.ILIKE);
        StringBuilder clause = new StringBuilder("plainSchema=?").append(MySQLJPAAnySearchDAO.setParameter(parameters, cond.getSchema())).append(" AND ").append(lower ? "LOWER(" : "").append((String)(schema.isUniqueConstraint() ? "JSON_UNQUOTE(JSON_EXTRACT(attrUniqueValue, '$." + key + "'))" : key)).append(lower ? Character.valueOf(')') : "");
        switch (cond.getType()) {
            case LIKE: 
            case ILIKE: {
                if (not) {
                    clause.append("NOT ");
                }
                clause.append(" LIKE ");
                break;
            }
            case GE: {
                if (not) {
                    clause.append('<');
                    break;
                }
                clause.append(">=");
                break;
            }
            case GT: {
                if (not) {
                    clause.append("<=");
                    break;
                }
                clause.append('>');
                break;
            }
            case LE: {
                if (not) {
                    clause.append('>');
                    break;
                }
                clause.append("<=");
                break;
            }
            case LT: {
                if (not) {
                    clause.append(">=");
                    break;
                }
                clause.append('<');
                break;
            }
            default: {
                if (not) {
                    clause.append('!');
                }
                clause.append('=');
            }
        }
        clause.append(lower ? "LOWER(" : "").append('?').append(MySQLJPAAnySearchDAO.setParameter(parameters, value)).append(lower ? ")" : "");
        return new AnySearchNode.Leaf(from, clause.toString());
    }

    @Override
    protected AbstractJPAAnySearchDAO.AttrCondQuery getQuery(AttrCond cond, boolean not, AbstractAnySearchDAO.CheckResult<AttrCond> checked, List<Object> parameters, SearchSupport svs) {
        AnySearchNode.Leaf node;
        if (not) {
            if (cond.getType() == AttrCond.Type.ISNULL) {
                cond.setType(AttrCond.Type.ISNOTNULL);
            } else if (cond.getType() == AttrCond.Type.ISNOTNULL) {
                cond.setType(AttrCond.Type.ISNULL);
            }
        }
        switch (cond.getType()) {
            case ISNOTNULL: {
                return new AbstractJPAAnySearchDAO.AttrCondQuery(true, new AnySearchNode.Leaf(svs.field(), "JSON_SEARCH(plainAttrs, 'one', '" + checked.schema().getKey() + "', NULL, '$[*].schema') IS NOT NULL"));
            }
            case ISNULL: {
                return new AbstractJPAAnySearchDAO.AttrCondQuery(true, new AnySearchNode.Leaf(svs.field(), "JSON_SEARCH(plainAttrs, 'one', '" + checked.schema().getKey() + "', NULL, '$[*].schema') IS NULL"));
            }
        }
        if (!not && cond.getType() == AttrCond.Type.EQ) {
            PlainAttr container = new PlainAttr();
            container.setPlainSchema(checked.schema());
            if (checked.schema().isUniqueConstraint()) {
                container.setUniqueValue(checked.value());
            } else {
                container.add(checked.value());
            }
            return new AbstractJPAAnySearchDAO.AttrCondQuery(true, new AnySearchNode.Leaf(svs.field(), "JSON_CONTAINS(plainAttrs, '" + POJOHelper.serialize(List.of(container)).replace("'", "''") + "')"));
        }
        if (not && checked.schema().isMultivalue()) {
            AnySearchNode.Leaf notNode = this.filJSONAttrQuery(svs.field(), checked.value(), checked.schema(), cond, false, parameters);
            node = new AnySearchNode.Leaf(notNode.getFrom(), "sv.any_id NOT IN (SELECT any_id FROM " + notNode.getFrom().name() + " WHERE " + notNode.getClause().replace(notNode.getFrom().alias() + ".", "") + ")");
        } else {
            node = this.filJSONAttrQuery(svs.field(), checked.value(), checked.schema(), cond, not, parameters);
        }
        return new AbstractJPAAnySearchDAO.AttrCondQuery(true, node);
    }
}

