/*
 * Decompiled with CFR 0.152.
 */
package com.duosecurity;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.Verification;
import com.duosecurity.TokenValidator;
import com.duosecurity.exception.DuoException;

public final class DuoIdTokenValidator
implements TokenValidator {
    private static final long DUO_LEEWAY = 60L;
    private static final String HTTPS = "https://";
    private static final String ISSUER_PATH = "/oauth/v1/token";
    private static final String NONCE_CLAIM = "nonce";
    private static final String USERNAME_CLAIM = "preferred_username";
    private final String clientSecret;
    private final String username;
    private final String audience;
    private final String issuer;
    private final String nonce;
    private long leeway = 60L;

    public DuoIdTokenValidator(String clientSecret, String username, String audience, String apiHost) {
        this(clientSecret, username, audience, apiHost, null);
    }

    public DuoIdTokenValidator(String clientSecret, String username, String audience, String apiHost, String nonce) {
        this.clientSecret = clientSecret;
        this.username = username;
        this.audience = audience;
        this.issuer = HTTPS + apiHost + ISSUER_PATH;
        this.nonce = nonce;
    }

    @Override
    public DecodedJWT validateAndDecode(String jwt) throws DuoException {
        if (jwt == null) {
            throw new DuoException("ID Token verification failed: Null token");
        }
        try {
            JWTVerifier verifier = this.buildVerifier();
            return verifier.verify(jwt);
        }
        catch (JWTVerificationException e) {
            throw new DuoException("ID Token verification failed", e);
        }
    }

    private JWTVerifier buildVerifier() {
        Algorithm signingAlgorithm = Algorithm.HMAC512((String)this.clientSecret);
        Verification verifier = JWT.require((Algorithm)signingAlgorithm).withIssuer(this.issuer).withAudience(new String[]{this.audience}).withClaim(USERNAME_CLAIM, this.username).acceptLeeway(this.leeway);
        if (this.nonce != null) {
            verifier.withClaim(NONCE_CLAIM, this.nonce);
        }
        return verifier.build();
    }
}

