/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.info;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.util.ClassUtils;

public class ProcessInfo {
    private static final String VIRTUAL_THREAD_SCHEDULER_CLASS = "jdk.management.VirtualThreadSchedulerMXBean";
    private static final boolean VIRTUAL_THREAD_SCHEDULER_CLASS_PRESENT = ClassUtils.isPresent((String)"jdk.management.VirtualThreadSchedulerMXBean", null);
    private static final Runtime runtime = Runtime.getRuntime();
    private final long pid;
    private final long parentPid;
    private final String owner;

    public ProcessInfo() {
        ProcessHandle process = ProcessHandle.current();
        this.pid = process.pid();
        this.parentPid = process.parent().map(ProcessHandle::pid).orElse(-1L);
        this.owner = process.info().user().orElse(null);
    }

    public int getCpus() {
        return runtime.availableProcessors();
    }

    public MemoryInfo getMemory() {
        return new MemoryInfo();
    }

    public VirtualThreadsInfo getVirtualThreads() {
        if (!VIRTUAL_THREAD_SCHEDULER_CLASS_PRESENT) {
            return null;
        }
        try {
            Class mxbeanClass = ClassUtils.forName((String)VIRTUAL_THREAD_SCHEDULER_CLASS, null);
            Object mxbean = ManagementFactory.getPlatformMXBean(mxbeanClass);
            int mountedVirtualThreadCount = (Integer)this.invokeMethod(mxbeanClass, mxbean, "getMountedVirtualThreadCount");
            long queuedVirtualThreadCount = (Long)this.invokeMethod(mxbeanClass, mxbean, "getQueuedVirtualThreadCount");
            int parallelism = (Integer)this.invokeMethod(mxbeanClass, mxbean, "getParallelism");
            int poolSize = (Integer)this.invokeMethod(mxbeanClass, mxbean, "getPoolSize");
            return new VirtualThreadsInfo(mountedVirtualThreadCount, queuedVirtualThreadCount, parallelism, poolSize);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private <T> T invokeMethod(Class<?> mxbeanClass, Object mxbean, String name) throws ReflectiveOperationException {
        Method method = mxbeanClass.getMethod(name, new Class[0]);
        return (T)method.invoke(mxbean, new Object[0]);
    }

    public long getPid() {
        return this.pid;
    }

    public long getParentPid() {
        return this.parentPid;
    }

    public String getOwner() {
        return this.owner;
    }

    public static class MemoryInfo {
        private static final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        private static final List<GarbageCollectorMXBean> garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
        private final MemoryUsageInfo heap = new MemoryUsageInfo(memoryMXBean.getHeapMemoryUsage());
        private final MemoryUsageInfo nonHeap = new MemoryUsageInfo(memoryMXBean.getNonHeapMemoryUsage());
        private final List<GarbageCollectorInfo> garbageCollectors = garbageCollectorMXBeans.stream().map(GarbageCollectorInfo::new).toList();

        MemoryInfo() {
        }

        public MemoryUsageInfo getHeap() {
            return this.heap;
        }

        public MemoryUsageInfo getNonHeap() {
            return this.nonHeap;
        }

        public List<GarbageCollectorInfo> getGarbageCollectors() {
            return this.garbageCollectors;
        }

        public static class MemoryUsageInfo {
            private final MemoryUsage memoryUsage;

            MemoryUsageInfo(MemoryUsage memoryUsage) {
                this.memoryUsage = memoryUsage;
            }

            public long getInit() {
                return this.memoryUsage.getInit();
            }

            public long getUsed() {
                return this.memoryUsage.getUsed();
            }

            public long getCommitted() {
                return this.memoryUsage.getCommitted();
            }

            public long getMax() {
                return this.memoryUsage.getMax();
            }
        }

        public static class GarbageCollectorInfo {
            private final String name;
            private final long collectionCount;

            GarbageCollectorInfo(GarbageCollectorMXBean garbageCollectorMXBean) {
                this.name = garbageCollectorMXBean.getName();
                this.collectionCount = garbageCollectorMXBean.getCollectionCount();
            }

            public String getName() {
                return this.name;
            }

            public long getCollectionCount() {
                return this.collectionCount;
            }
        }
    }

    public static class VirtualThreadsInfo {
        private final int mounted;
        private final long queued;
        private final int parallelism;
        private final int poolSize;

        VirtualThreadsInfo(int mounted, long queued, int parallelism, int poolSize) {
            this.mounted = mounted;
            this.queued = queued;
            this.parallelism = parallelism;
            this.poolSize = poolSize;
        }

        public int getMounted() {
            return this.mounted;
        }

        public long getQueued() {
            return this.queued;
        }

        public int getParallelism() {
            return this.parallelism;
        }

        public int getPoolSize() {
            return this.poolSize;
        }
    }
}

