/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.bypass;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.bypass.BaseMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderBypassProperties;
import org.apereo.cas.services.RegisteredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class CredentialMultifactorAuthenticationProviderBypassEvaluator
extends BaseMultifactorAuthenticationProviderBypassEvaluator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CredentialMultifactorAuthenticationProviderBypassEvaluator.class);
    private static final long serialVersionUID = -1233888418344342672L;
    private final MultifactorAuthenticationProviderBypassProperties bypassProperties;

    public CredentialMultifactorAuthenticationProviderBypassEvaluator(MultifactorAuthenticationProviderBypassProperties bypassProperties, String providerId, ConfigurableApplicationContext applicationContext) {
        super(providerId, (ApplicationContext)applicationContext);
        this.bypassProperties = bypassProperties;
    }

    protected static boolean locateMatchingCredentialType(Authentication authentication, String credentialClassType) {
        return StringUtils.isNotBlank((CharSequence)credentialClassType) && authentication.getCredentials().stream().anyMatch(e -> Objects.nonNull(e.getCredentialMetadata()) && e.getCredentialMetadata().getCredentialClass().getName().matches(credentialClassType));
    }

    @Override
    public boolean shouldMultifactorAuthenticationProviderExecuteInternal(Authentication authentication, RegisteredService registeredService, MultifactorAuthenticationProvider provider, HttpServletRequest request) {
        boolean bypassByCredType = CredentialMultifactorAuthenticationProviderBypassEvaluator.locateMatchingCredentialType(authentication, this.bypassProperties.getCredentialClassType());
        if (bypassByCredType) {
            LOGGER.debug("Bypass rules for credential types [{}] indicate the request may be ignored", (Object)this.bypassProperties.getCredentialClassType());
            return false;
        }
        return true;
    }
}

