/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.openejb.jee.KeyExtractor;
import org.apache.openejb.jee.Keyable;

public class KeyedCollection<K, V>
extends AbstractCollection<V> {
    private final KeyExtractor<? extends K, ? super V> keyExtractor;
    private final LinkedHashMap<K, V> map;

    public KeyedCollection() {
        this.keyExtractor = null;
        this.map = new LinkedHashMap();
    }

    public KeyedCollection(KeyExtractor<? extends K, ? super V> keyExtractor) {
        this.keyExtractor = keyExtractor;
        this.map = new LinkedHashMap();
    }

    public KeyedCollection(Collection<? extends V> c) {
        if (c instanceof KeyedCollection) {
            KeyedCollection keyedCollection = (KeyedCollection)c;
            this.keyExtractor = keyedCollection.keyExtractor;
        } else {
            this.keyExtractor = null;
        }
        this.map = new LinkedHashMap();
        this.addAll(c);
    }

    public KeyedCollection(int initialCapacity) {
        this.keyExtractor = null;
        this.map = new LinkedHashMap(initialCapacity);
    }

    public Map<K, V> toMap() {
        return this.map;
    }

    @Override
    public boolean add(V value) {
        K key = this.getKey(value);
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        V oldValue = this.map.put(key, value);
        return value != oldValue;
    }

    @Override
    public Iterator<V> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public String toString() {
        return this.map.toString();
    }

    protected K getKey(V value) {
        if (this.keyExtractor == null) {
            return ((Keyable)value).getKey();
        }
        return this.keyExtractor.getKey(value);
    }
}

