/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.fallback;

import io.smallrye.faulttolerance.core.FailureContext;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.fallback.Fallback;
import io.smallrye.faulttolerance.core.fallback.FallbackEvents;
import io.smallrye.faulttolerance.core.fallback.FallbackLogger;
import io.smallrye.faulttolerance.core.util.CompletionStages;
import io.smallrye.faulttolerance.core.util.ExceptionDecision;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public class CompletionStageFallback<V>
extends Fallback<CompletionStage<V>> {
    public CompletionStageFallback(FaultToleranceStrategy<CompletionStage<V>> delegate, String description, Function<FailureContext, CompletionStage<V>> fallback, ExceptionDecision exceptionDecision) {
        super(delegate, description, fallback, exceptionDecision);
    }

    @Override
    public CompletionStage<V> apply(InvocationContext<CompletionStage<V>> ctx) {
        FallbackLogger.LOG.trace("CompletionStageFallback started");
        try {
            CompletionStage<V> completionStage = this.doApply(ctx);
            return completionStage;
        }
        finally {
            FallbackLogger.LOG.trace("CompletionStageFallback finished");
        }
    }

    private CompletionStage<V> doApply(InvocationContext<CompletionStage<V>> ctx) {
        CompletionStage<Object> originalResult;
        ctx.fireEvent(FallbackEvents.Defined.INSTANCE);
        CompletableFuture result = new CompletableFuture();
        try {
            originalResult = this.delegate.apply(ctx);
        }
        catch (Exception e) {
            originalResult = CompletableFuture.failedFuture(e);
        }
        originalResult.whenComplete((value, exception) -> {
            if (exception == null) {
                result.complete(value);
                return;
            }
            if (this.shouldSkipFallback((Throwable)exception)) {
                result.completeExceptionally((Throwable)exception);
                return;
            }
            try {
                FallbackLogger.LOG.debugf("%s invocation failed, invoking fallback", this.description);
                ctx.fireEvent(FallbackEvents.Applied.INSTANCE);
                CompletionStages.propagateCompletion((CompletionStage)this.fallback.apply(new FailureContext((Throwable)exception, ctx)), result);
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }
}

