/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.api;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.TypeUtil;

public interface Stream {
    public int getId();

    public Listener getListener();

    public Session getSession();

    default public CompletableFuture<Stream> headers(HeadersFrame frame) {
        return Promise.Completable.with(p -> this.headers(frame, Callback.from(() -> p.succeeded((Object)this), arg_0 -> ((Promise)p).failed(arg_0))));
    }

    public void headers(HeadersFrame var1, Callback var2);

    default public CompletableFuture<Stream> push(PushPromiseFrame frame, Listener listener) {
        return Promise.Completable.with(p -> this.push(frame, (Promise<Stream>)p, listener));
    }

    public void push(PushPromiseFrame var1, Promise<Stream> var2, Listener var3);

    public Data readData();

    default public CompletableFuture<Stream> data(DataFrame frame) {
        return Promise.Completable.with(p -> this.data(frame, Callback.from(() -> p.succeeded((Object)this), arg_0 -> ((Promise)p).failed(arg_0))));
    }

    public void data(DataFrame var1, Callback var2);

    default public CompletableFuture<Void> reset(ResetFrame frame) {
        return Callback.Completable.with(c -> this.reset(frame, (Callback)c));
    }

    public void reset(ResetFrame var1, Callback var2);

    public Object getAttribute(String var1);

    public void setAttribute(String var1, Object var2);

    public Object removeAttribute(String var1);

    public boolean isLocal();

    public boolean isReset();

    public boolean isRemotelyClosed();

    public boolean isClosed();

    public long getIdleTimeout();

    public void setIdleTimeout(long var1);

    public void demand();

    public static interface Listener {
        public static final Listener AUTO_DISCARD = new Listener(){};

        default public void onNewStream(Stream stream) {
        }

        default public void onHeaders(Stream stream, HeadersFrame frame) {
            if (!frame.isEndStream()) {
                stream.demand();
            }
        }

        default public void onHeaders(Stream stream, HeadersFrame frame, Callback callback) {
            this.onHeaders(stream, frame);
            callback.succeeded();
        }

        default public Listener onPush(Stream stream, PushPromiseFrame frame) {
            stream.demand();
            return AUTO_DISCARD;
        }

        default public void onDataAvailable(Stream stream) {
            Data data;
            do {
                if ((data = stream.readData()) == null) {
                    stream.demand();
                    return;
                }
                data.release();
            } while (!data.frame().isEndStream());
        }

        default public void onDataAvailable(Stream stream, boolean immediate) {
            this.onDataAvailable(stream);
        }

        default public void onReset(Stream stream, ResetFrame frame, Callback callback) {
            callback.succeeded();
        }

        default public void onIdleTimeout(Stream stream, TimeoutException x, Promise<Boolean> promise) {
            promise.succeeded((Object)true);
        }

        default public void onFailure(Stream stream, int error, String reason, Throwable failure, Callback callback) {
            callback.succeeded();
        }

        default public void onClosed(Stream stream) {
        }
    }

    public static abstract class Data
    implements Retainable {
        private final DataFrame frame;

        public static Data eof(int streamId) {
            return new EOF(streamId);
        }

        public Data(DataFrame frame) {
            this.frame = frame;
        }

        public DataFrame frame() {
            return this.frame;
        }

        public String toString() {
            return "%s@%x[%s]".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode(), this.frame());
        }

        private static class EOF
        extends Data {
            private EOF(int streamId) {
                super(new DataFrame(streamId, BufferUtil.EMPTY_BUFFER, true));
            }
        }
    }
}

