/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionRequestInfo;
import org.apache.activemq.artemis.utils.sm.SecurityManagerShim;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQRACredential
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final long serialVersionUID = 210476602237497193L;
    private String userName;
    private String password;

    private ActiveMQRACredential() {
        logger.trace("constructor()");
    }

    public String getUserName() {
        logger.trace("getUserName()");
        return this.userName;
    }

    private void setUserName(String userName) {
        logger.trace("setUserName({})", (Object)userName);
        this.userName = userName;
    }

    public String getPassword() {
        logger.trace("getPassword()");
        return this.password;
    }

    private void setPassword(String password) {
        logger.trace("setPassword(****)");
        this.password = password;
    }

    public static ActiveMQRACredential getCredential(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info) throws SecurityException {
        if (logger.isTraceEnabled()) {
            logger.trace("getCredential({}, {} ,{})", new Object[]{mcf, subject, info});
        }
        ActiveMQRACredential jc = new ActiveMQRACredential();
        if (subject == null && info != null) {
            jc.setUserName(((ActiveMQRAConnectionRequestInfo)info).getUserName());
            jc.setPassword(((ActiveMQRAConnectionRequestInfo)info).getPassword());
        } else if (subject != null) {
            PasswordCredential pwdc = GetCredentialAction.getCredential(subject, mcf);
            if (pwdc == null) {
                throw new SecurityException("No password credentials found");
            }
            jc.setUserName(pwdc.getUserName());
            jc.setPassword(new String(pwdc.getPassword()));
        } else {
            throw new SecurityException("No Subject or ConnectionRequestInfo set, could not get credentials");
        }
        return jc;
    }

    public String toString() {
        logger.trace("toString()");
        return super.toString() + "{ username=" + this.userName + ", password=**** }";
    }

    private static class GetCredentialAction
    implements PrivilegedAction<PasswordCredential> {
        private final Subject subject;
        private final ManagedConnectionFactory mcf;

        GetCredentialAction(Subject subject, ManagedConnectionFactory mcf) {
            logger.trace("constructor({}, {})", (Object)subject, (Object)mcf);
            this.subject = subject;
            this.mcf = mcf;
        }

        @Override
        public PasswordCredential run() {
            logger.trace("run()");
            Set<PasswordCredential> creds = this.subject.getPrivateCredentials(PasswordCredential.class);
            PasswordCredential pwdc = null;
            for (PasswordCredential curCred : creds) {
                if (!curCred.getManagedConnectionFactory().equals((Object)this.mcf)) continue;
                pwdc = curCred;
                break;
            }
            return pwdc;
        }

        static PasswordCredential getCredential(Subject subject, ManagedConnectionFactory mcf) {
            logger.trace("getCredential({}, {})", (Object)subject, (Object)mcf);
            GetCredentialAction action = new GetCredentialAction(subject, mcf);
            return (PasswordCredential)SecurityManagerShim.doPrivileged((PrivilegedAction)action);
        }
    }
}

