/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.netty;

import io.netty.channel.Channel;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnection;
import org.apache.activemq.artemis.spi.core.remoting.BaseConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.ServerConnectionLifeCycleListener;
import org.apache.activemq.artemis.utils.CertificateUtil;
import org.apache.activemq.artemis.utils.ProxyProtocolUtil;

public class NettyServerConnection
extends NettyConnection {
    private String sniHostname;
    private final String router;
    private X509Certificate[] certificates;

    public NettyServerConnection(Map<String, Object> configuration, Channel channel, ServerConnectionLifeCycleListener listener, boolean batchingEnabled, boolean directDeliver, String router) {
        super(configuration, channel, (BaseConnectionLifeCycleListener)listener, batchingEnabled, directDeliver);
        this.router = router;
    }

    public String getSNIHostName() {
        return this.sniHostname;
    }

    public void setSNIHostname(String sniHostname) {
        this.sniHostname = sniHostname;
    }

    public String getRouter() {
        return this.router;
    }

    public X509Certificate[] getPeerCertificates() {
        if (this.certificates == null) {
            this.certificates = CertificateUtil.getCertsFromChannel(this.channel);
        }
        return this.certificates;
    }

    public String getRemoteAddress() {
        return ProxyProtocolUtil.getRemoteAddress((Channel)this.channel);
    }

    public String getProxyAddress() {
        return ProxyProtocolUtil.getProxyAddress((Channel)this.channel);
    }

    public String getProxyProtocolVersion() {
        return ProxyProtocolUtil.getProxyProtocolVersion((Channel)this.channel);
    }

    public static String getProxyAddress(Connection connection) {
        if (connection instanceof NettyServerConnection) {
            NettyServerConnection nettyServerConnection = (NettyServerConnection)connection;
            return nettyServerConnection.getProxyAddress();
        }
        return null;
    }

    public static String getProxyProtocolVersion(Connection connection) {
        if (connection instanceof NettyServerConnection) {
            NettyServerConnection nettyServerConnection = (NettyServerConnection)connection;
            return nettyServerConnection.getProxyProtocolVersion();
        }
        return null;
    }
}

