/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.cayenne.configuration.xml.LoaderContext;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXNestedTagHandler
extends DefaultHandler {
    private static final Locator NOOP_LOCATOR = new Locator(){

        @Override
        public int getColumnNumber() {
            return -1;
        }

        @Override
        public int getLineNumber() {
            return -1;
        }

        @Override
        public String getPublicId() {
            return "<unknown>";
        }

        @Override
        public String getSystemId() {
            return "<unknown>";
        }
    };
    protected LoaderContext loaderContext;
    protected ContentHandler parentHandler;
    protected Locator locator;

    public SAXNestedTagHandler(LoaderContext loaderContext) {
        this.loaderContext = Objects.requireNonNull(loaderContext);
        this.locator = NOOP_LOCATOR;
    }

    public SAXNestedTagHandler(SAXNestedTagHandler parentHandler) {
        this.parentHandler = Objects.requireNonNull(parentHandler);
        this.loaderContext = Objects.requireNonNull(parentHandler.loaderContext);
        this.locator = parentHandler.locator;
        if (this.locator == null) {
            this.locator = NOOP_LOCATOR;
        }
    }

    protected String unexpectedTagMessage(String tagFound, String ... tagsExpected) {
        List<Object> expected = tagsExpected != null ? Arrays.asList(tagsExpected) : Collections.emptyList();
        return String.format("tag <%s> is unexpected at [%d,%d]. The following tags are allowed here: %s", tagFound, this.locator.getColumnNumber(), this.locator.getLineNumber(), expected);
    }

    protected boolean processElement(String namespaceURI, String localName, Attributes attributes) throws SAXException {
        return true;
    }

    protected void beforeScopeEnd() {
    }

    protected ContentHandler createChildTagHandler(String namespaceURI, String localName, String qName, Attributes attributes) {
        return new SAXNestedTagHandler(this);
    }

    protected void stop() {
        this.beforeScopeEnd();
        this.loaderContext.getXmlReader().setContentHandler(this.parentHandler);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        ContentHandler childHandler = this.createChildTagHandler(namespaceURI, localName, qName, attributes);
        if (!this.processElement(namespaceURI, localName, attributes)) {
            childHandler.startElement(namespaceURI, localName, qName, attributes);
        }
        this.loaderContext.getXmlReader().setContentHandler(childHandler);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.stop();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public ContentHandler getParentHandler() {
        return this.parentHandler;
    }
}

