/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.dtdparser;

import java.util.Arrays;
import java.util.Enumeration;

final class SimpleHashtable<K, V>
implements Enumeration<K> {
    private Entry<K, V>[] table;
    private Entry<K, V> current = null;
    private int currentBucket = 0;
    private int count;
    private int threshold;
    private static final float loadFactor = 0.75f;

    public SimpleHashtable(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * 0.75f);
    }

    public SimpleHashtable() {
        this(11);
    }

    public void clear() {
        this.count = 0;
        this.currentBucket = 0;
        this.current = null;
        Arrays.fill(this.table, null);
    }

    public int size() {
        return this.count;
    }

    public Enumeration<K> keys() {
        this.currentBucket = 0;
        this.current = null;
        return this;
    }

    @Override
    public boolean hasMoreElements() {
        if (this.current != null) {
            return true;
        }
        while (this.currentBucket < this.table.length) {
            this.current = this.table[this.currentBucket++];
            if (this.current == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public K nextElement() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        Object retval = this.current.key;
        this.current = this.current.next;
        return retval;
    }

    public V get(String key) {
        Entry<K, V>[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<K, V> e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public V getNonInterned(String key) {
        Entry<K, V>[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<K, V> e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        Entry<K, V>[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * 0.75f);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry<K, V> old = oldMap[i];
            while (old != null) {
                Entry<K, V> e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public V put(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Entry<K, V>[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<K, V> e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new Entry<K, V>(hash, key, value, tab[index]);
        ++this.count;
        return null;
    }

    private static class Entry<K, V> {
        int hash;
        K key;
        V value;
        Entry<K, V> next;

        protected Entry(int hash, K key, V value, Entry<K, V> next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

