/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.api.tools;

import java.util.Objects;

public class ToolResponse {
    private final Object result;
    private final boolean success;
    private final String error;
    private final long executionTimeMs;
    private final String toolName;

    private ToolResponse(Object result, boolean success, String error, long executionTimeMs, String toolName) {
        this.result = result;
        this.success = success;
        this.error = error;
        this.executionTimeMs = executionTimeMs;
        this.toolName = toolName;
    }

    public static ToolResponse success(Object result) {
        return new ToolResponse(result, true, null, 0L, null);
    }

    public static ToolResponse success(Object result, long executionTimeMs) {
        return new ToolResponse(result, true, null, executionTimeMs, null);
    }

    public static ToolResponse success(Object result, long executionTimeMs, String toolName) {
        return new ToolResponse(result, true, null, executionTimeMs, toolName);
    }

    public static ToolResponse error(String error) {
        return new ToolResponse(null, false, Objects.requireNonNull(error, "error cannot be null"), 0L, null);
    }

    public static ToolResponse error(String error, long executionTimeMs) {
        return new ToolResponse(null, false, Objects.requireNonNull(error, "error cannot be null"), executionTimeMs, null);
    }

    public static ToolResponse error(String error, long executionTimeMs, String toolName) {
        return new ToolResponse(null, false, Objects.requireNonNull(error, "error cannot be null"), executionTimeMs, toolName);
    }

    public static ToolResponse error(Throwable throwable) {
        String errorMessage = throwable.getMessage();
        if (errorMessage == null || errorMessage.isEmpty()) {
            errorMessage = throwable.getClass().getSimpleName();
        }
        return new ToolResponse(null, false, errorMessage, 0L, null);
    }

    public static ToolResponse error(Throwable throwable, long executionTimeMs) {
        String errorMessage = throwable.getMessage();
        if (errorMessage == null || errorMessage.isEmpty()) {
            errorMessage = throwable.getClass().getSimpleName();
        }
        return new ToolResponse(null, false, errorMessage, executionTimeMs, null);
    }

    public Object getResult() {
        return this.result;
    }

    public <T> T getResult(Class<T> type) {
        if (this.result == null) {
            return null;
        }
        if (type.isAssignableFrom(this.result.getClass())) {
            return (T)this.result;
        }
        throw new ClassCastException(String.format("Cannot cast result of type %s to %s", this.result.getClass().getSimpleName(), type.getSimpleName()));
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isError() {
        return !this.success;
    }

    public String getError() {
        return this.error;
    }

    public long getExecutionTimeMs() {
        return this.executionTimeMs;
    }

    public String getToolName() {
        return this.toolName;
    }

    public String getResultAsString() {
        if (this.result == null) {
            return null;
        }
        return this.result.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ToolResponse that = (ToolResponse)o;
        return this.success == that.success && this.executionTimeMs == that.executionTimeMs && Objects.equals(this.result, that.result) && Objects.equals(this.error, that.error) && Objects.equals(this.toolName, that.toolName);
    }

    public int hashCode() {
        return Objects.hash(this.result, this.success, this.error, this.executionTimeMs, this.toolName);
    }

    public String toString() {
        if (this.success) {
            return this.getResultAsString();
        }
        return this.error;
    }
}

