/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class TreeFilterMarker {
    private final TreeFilter[] filters;

    public TreeFilterMarker(TreeFilter[] markTreeFilters) {
        if (markTreeFilters.length > 32) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().treeFilterMarkerTooManyFilters, 32, markTreeFilters.length));
        }
        this.filters = new TreeFilter[markTreeFilters.length];
        System.arraycopy(markTreeFilters, 0, this.filters, 0, markTreeFilters.length);
    }

    public int getMarks(TreeWalk walk) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        int marks = 0;
        int index2 = 0;
        while (index2 < this.filters.length) {
            TreeFilter filter2 = this.filters[index2];
            if (filter2 != null) {
                try {
                    boolean marked = filter2.include(walk);
                    if (marked) {
                        marks |= 1 << index2;
                    }
                }
                catch (StopWalkException e) {
                    this.filters[index2] = null;
                }
            }
            ++index2;
        }
        return marks;
    }
}

