/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.servlet;

import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.validation.DefaultMessageCodesResolver;

@ConfigurationProperties(value="spring.mvc")
public class WebMvcProperties {
    private DefaultMessageCodesResolver.Format messageCodesResolverFormat;
    private final Format format = new Format();
    private boolean dispatchTraceRequest = false;
    private boolean dispatchOptionsRequest = true;
    private boolean publishRequestHandledEvents = true;
    private boolean logRequestDetails;
    private boolean logResolvedException = false;
    private String staticPathPattern = "/**";
    private String webjarsPathPattern = "/webjars/**";
    private final Async async = new Async();
    private final Servlet servlet = new Servlet();
    private final View view = new View();
    private final Contentnegotiation contentnegotiation = new Contentnegotiation();
    private final Pathmatch pathmatch = new Pathmatch();
    private final Problemdetails problemdetails = new Problemdetails();

    public DefaultMessageCodesResolver.Format getMessageCodesResolverFormat() {
        return this.messageCodesResolverFormat;
    }

    public void setMessageCodesResolverFormat(DefaultMessageCodesResolver.Format messageCodesResolverFormat) {
        this.messageCodesResolverFormat = messageCodesResolverFormat;
    }

    public Format getFormat() {
        return this.format;
    }

    public boolean isPublishRequestHandledEvents() {
        return this.publishRequestHandledEvents;
    }

    public void setPublishRequestHandledEvents(boolean publishRequestHandledEvents) {
        this.publishRequestHandledEvents = publishRequestHandledEvents;
    }

    public boolean isLogRequestDetails() {
        return this.logRequestDetails;
    }

    public void setLogRequestDetails(boolean logRequestDetails) {
        this.logRequestDetails = logRequestDetails;
    }

    public boolean isLogResolvedException() {
        return this.logResolvedException;
    }

    public void setLogResolvedException(boolean logResolvedException) {
        this.logResolvedException = logResolvedException;
    }

    public boolean isDispatchOptionsRequest() {
        return this.dispatchOptionsRequest;
    }

    public void setDispatchOptionsRequest(boolean dispatchOptionsRequest) {
        this.dispatchOptionsRequest = dispatchOptionsRequest;
    }

    public boolean isDispatchTraceRequest() {
        return this.dispatchTraceRequest;
    }

    public void setDispatchTraceRequest(boolean dispatchTraceRequest) {
        this.dispatchTraceRequest = dispatchTraceRequest;
    }

    public String getStaticPathPattern() {
        return this.staticPathPattern;
    }

    public void setStaticPathPattern(String staticPathPattern) {
        this.staticPathPattern = staticPathPattern;
    }

    public String getWebjarsPathPattern() {
        return this.webjarsPathPattern;
    }

    public void setWebjarsPathPattern(String webjarsPathPattern) {
        this.webjarsPathPattern = webjarsPathPattern;
    }

    public Async getAsync() {
        return this.async;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public View getView() {
        return this.view;
    }

    public Contentnegotiation getContentnegotiation() {
        return this.contentnegotiation;
    }

    public Pathmatch getPathmatch() {
        return this.pathmatch;
    }

    public Problemdetails getProblemdetails() {
        return this.problemdetails;
    }

    public static class Format {
        private String date;
        private String time;
        private String dateTime;

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public String getTime() {
            return this.time;
        }

        public void setTime(String time) {
            this.time = time;
        }

        public String getDateTime() {
            return this.dateTime;
        }

        public void setDateTime(String dateTime) {
            this.dateTime = dateTime;
        }
    }

    public static class Async {
        private Duration requestTimeout;

        public Duration getRequestTimeout() {
            return this.requestTimeout;
        }

        public void setRequestTimeout(Duration requestTimeout) {
            this.requestTimeout = requestTimeout;
        }
    }

    public static class Servlet {
        private String path = "/";
        private int loadOnStartup = -1;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            Assert.notNull((Object)path, "'path' must not be null");
            Assert.isTrue(!path.contains("*"), "'path' must not contain wildcards");
            this.path = path;
        }

        public int getLoadOnStartup() {
            return this.loadOnStartup;
        }

        public void setLoadOnStartup(int loadOnStartup) {
            this.loadOnStartup = loadOnStartup;
        }

        public String getServletMapping() {
            if (this.path.isEmpty() || this.path.equals("/")) {
                return "/";
            }
            if (this.path.endsWith("/")) {
                return this.path + "*";
            }
            return this.path + "/*";
        }

        public String getPath(String path) {
            String prefix = this.getServletPrefix();
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            return prefix + (String)path;
        }

        public String getServletPrefix() {
            String result = this.path;
            int index2 = result.indexOf(42);
            if (index2 != -1) {
                result = result.substring(0, index2);
            }
            if (result.endsWith("/")) {
                result = result.substring(0, result.length() - 1);
            }
            return result;
        }
    }

    public static class View {
        private String prefix;
        private String suffix;

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }
    }

    public static class Contentnegotiation {
        private boolean favorParameter = false;
        private String parameterName;
        private Map<String, MediaType> mediaTypes = new LinkedHashMap<String, MediaType>();
        private List<MediaType> defaultContentTypes = new ArrayList<MediaType>();

        public boolean isFavorParameter() {
            return this.favorParameter;
        }

        public void setFavorParameter(boolean favorParameter) {
            this.favorParameter = favorParameter;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        public Map<String, MediaType> getMediaTypes() {
            return this.mediaTypes;
        }

        public void setMediaTypes(Map<String, MediaType> mediaTypes) {
            this.mediaTypes = mediaTypes;
        }

        public List<MediaType> getDefaultContentTypes() {
            return this.defaultContentTypes;
        }

        public void setDefaultContentTypes(List<MediaType> defaultContentTypes) {
            this.defaultContentTypes = defaultContentTypes;
        }
    }

    public static class Pathmatch {
        private MatchingStrategy matchingStrategy = MatchingStrategy.PATH_PATTERN_PARSER;

        public MatchingStrategy getMatchingStrategy() {
            return this.matchingStrategy;
        }

        public void setMatchingStrategy(MatchingStrategy matchingStrategy) {
            this.matchingStrategy = matchingStrategy;
        }
    }

    public static class Problemdetails {
        private boolean enabled = false;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static enum MatchingStrategy {
        ANT_PATH_MATCHER,
        PATH_PATTERN_PARSER;

    }
}

