/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.multipart;

import java.util.Collections;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.multipart.MultipartWriterSupport;
import org.springframework.http.codec.multipart.PartEvent;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PartEventHttpMessageWriter
extends MultipartWriterSupport
implements HttpMessageWriter<PartEvent> {
    public PartEventHttpMessageWriter() {
        super(Collections.singletonList(MediaType.MULTIPART_FORM_DATA));
    }

    @Override
    public boolean canWrite(ResolvableType elementType, @Nullable MediaType mediaType) {
        if (PartEvent.class.isAssignableFrom(elementType.toClass())) {
            if (mediaType == null) {
                return true;
            }
            for (MediaType supportedMediaType : this.getWritableMediaTypes()) {
                if (!supportedMediaType.isCompatibleWith(mediaType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Mono<Void> write(Publisher<? extends PartEvent> partDataStream, ResolvableType elementType, @Nullable MediaType mediaType, ReactiveHttpOutputMessage outputMessage, Map<String, Object> hints) {
        byte[] boundary = this.generateMultipartBoundary();
        mediaType = this.getMultipartMediaType(mediaType, boundary);
        outputMessage.getHeaders().setContentType(mediaType);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Hints.getLogPrefix(hints) + "Encoding Publisher<PartEvent>");
        }
        Flux<DataBuffer> body2 = Flux.from(partDataStream).windowUntil(PartEvent::isLast).concatMap(partData -> partData.switchOnFirst((signal, flux) -> {
            if (signal.hasValue()) {
                PartEvent value = (PartEvent)signal.get();
                Assert.state(value != null, "Null value");
                Flux<DataBuffer> dataBuffers = flux.map(PartEvent::content).filter(buffer -> buffer.readableByteCount() > 0);
                return this.encodePartData(boundary, outputMessage.bufferFactory(), value.headers(), dataBuffers);
            }
            return flux.cast(DataBuffer.class);
        })).concatWith(this.generateLastLine(boundary, outputMessage.bufferFactory())).doOnDiscard(DataBuffer.class, DataBufferUtils::release);
        if (this.logger.isDebugEnabled()) {
            body2 = body2.doOnNext(buffer -> Hints.touchDataBuffer(buffer, hints, this.logger));
        }
        return outputMessage.writeWith(body2);
    }

    private Flux<DataBuffer> encodePartData(byte[] boundary, DataBufferFactory bufferFactory, HttpHeaders headers, Flux<DataBuffer> body2) {
        return Flux.concat(this.generateBoundaryLine(boundary, bufferFactory), this.generatePartHeaders(headers, bufferFactory), body2, this.generateNewLine(bufferFactory));
    }
}

