/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.jupiter.api.MethodDescriptor;
import org.junit.jupiter.api.MethodOrdererContext;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.RandomOrdererUtils;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ClassUtils;

@API(status=API.Status.STABLE, since="5.7")
public interface MethodOrderer {
    @API(status=API.Status.STABLE, since="5.9")
    public static final String DEFAULT_ORDER_PROPERTY_NAME = "junit.jupiter.testmethod.order.default";

    public void orderMethods(MethodOrdererContext var1);

    default public Optional<ExecutionMode> getDefaultExecutionMode() {
        return Optional.of(ExecutionMode.SAME_THREAD);
    }

    public static class Random
    implements MethodOrderer {
        private static final Logger logger = LoggerFactory.getLogger(Random.class);
        public static final String RANDOM_SEED_PROPERTY_NAME = "junit.jupiter.execution.order.random.seed";

        @Override
        public void orderMethods(MethodOrdererContext context) {
            Collections.shuffle(context.getMethodDescriptors(), new java.util.Random(RandomOrdererUtils.getSeed(context::getConfigurationParameter, logger)));
        }

        static {
            logger.config(() -> "MethodOrderer.Random default seed: " + RandomOrdererUtils.DEFAULT_SEED);
        }
    }

    public static class OrderAnnotation
    implements MethodOrderer {
        @Override
        public void orderMethods(MethodOrdererContext context) {
            context.getMethodDescriptors().sort(Comparator.comparingInt(OrderAnnotation::getOrder));
        }

        private static int getOrder(MethodDescriptor descriptor) {
            return descriptor.findAnnotation(Order.class).map(Order::value).orElse(0x3FFFFFFF);
        }
    }

    @API(status=API.Status.STABLE, since="5.10")
    public static class DisplayName
    implements MethodOrderer {
        private static final Comparator<MethodDescriptor> comparator = Comparator.comparing(MethodDescriptor::getDisplayName);

        @Override
        public void orderMethods(MethodOrdererContext context) {
            context.getMethodDescriptors().sort(comparator);
        }
    }

    @API(status=API.Status.STABLE, since="5.10")
    public static class MethodName
    implements MethodOrderer {
        private static final Comparator<MethodDescriptor> comparator = Comparator.comparing(descriptor -> descriptor.getMethod().getName()).thenComparing(descriptor -> MethodName.parameterList(descriptor.getMethod()));

        @Override
        public void orderMethods(MethodOrdererContext context) {
            context.getMethodDescriptors().sort(comparator);
        }

        private static String parameterList(Method method) {
            return ClassUtils.nullSafeToString((Class[])method.getParameterTypes());
        }
    }

    @API(status=API.Status.DEPRECATED, since="5.7")
    @Deprecated
    public static class Alphanumeric
    extends MethodName {
    }
}

