/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeSet;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.S;

public class QueryEntityIndexDescriptor
implements GridQueryIndexDescriptor {
    private final Collection<T2<String, Integer>> fields = new TreeSet<T2<String, Integer>>(new Comparator<T2<String, Integer>>(){

        @Override
        public int compare(T2<String, Integer> o1, T2<String, Integer> o2) {
            if (((Integer)o1.get2()).equals(o2.get2())) {
                return ((String)o1.get1()).compareTo((String)o2.get1());
            }
            return (Integer)o1.get2() < (Integer)o2.get2() ? -1 : 1;
        }
    });
    private final QueryIndexType type;
    private final int inlineSize;
    private Collection<String> descendings;

    QueryEntityIndexDescriptor(QueryIndexType type, int inlineSize) {
        assert (type != null);
        this.type = type;
        this.inlineSize = inlineSize;
    }

    QueryEntityIndexDescriptor(QueryIndexType type) {
        this(type, -1);
    }

    @Override
    public String name() {
        return null;
    }

    @Override
    public Collection<String> fields() {
        ArrayList<String> res = new ArrayList<String>(this.fields.size());
        for (T2<String, Integer> t : this.fields) {
            res.add((String)t.get1());
        }
        return res;
    }

    @Override
    public boolean descending(String field) {
        return this.descendings != null && this.descendings.contains(field);
    }

    public void addField(String field, int orderNum, boolean descending) {
        this.fields.add(new T2<String, Integer>(field, orderNum));
        if (descending) {
            if (this.descendings == null) {
                this.descendings = new HashSet<String>();
            }
            this.descendings.add(field);
        }
    }

    @Override
    public QueryIndexType type() {
        return this.type;
    }

    @Override
    public int inlineSize() {
        return this.inlineSize;
    }

    public String toString() {
        return S.toString(QueryEntityIndexDescriptor.class, this);
    }
}

