/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.range;

import com.google.protobuf.ByteString;
import org.apache.bifromq.basekv.localengine.IRestoreSession;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.State;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.apache.bifromq.basekv.store.range.IKVRangeRestoreSession;
import org.apache.bifromq.basekv.store.range.KVRangeKeys;
import org.apache.bifromq.basekv.store.util.KVUtil;

class KVRangeRestoreSession
implements IKVRangeRestoreSession {
    private final IRestoreSession restoreSession;

    KVRangeRestoreSession(IRestoreSession restoreSession) {
        this.restoreSession = restoreSession;
    }

    @Override
    public void done() {
        this.restoreSession.done();
    }

    @Override
    public void abort() {
        this.restoreSession.abort();
    }

    @Override
    public int count() {
        return this.restoreSession.count();
    }

    @Override
    public IKVRangeRestoreSession ver(long ver) {
        this.restoreSession.metadata(KVRangeKeys.METADATA_VER_BYTES, KVUtil.toByteStringNativeOrder(ver));
        return this;
    }

    @Override
    public IKVRangeRestoreSession lastAppliedIndex(long lastAppliedIndex) {
        this.restoreSession.metadata(KVRangeKeys.METADATA_LAST_APPLIED_INDEX_BYTES, KVUtil.toByteString(lastAppliedIndex));
        return this;
    }

    @Override
    public IKVRangeRestoreSession boundary(Boundary boundary) {
        this.restoreSession.metadata(KVRangeKeys.METADATA_RANGE_BOUND_BYTES, boundary.toByteString());
        return this;
    }

    @Override
    public IKVRangeRestoreSession state(State state) {
        this.restoreSession.metadata(KVRangeKeys.METADATA_STATE_BYTES, state.toByteString());
        return this;
    }

    @Override
    public IKVRangeRestoreSession clusterConfig(ClusterConfig clusterConfig) {
        this.restoreSession.metadata(KVRangeKeys.METADATA_CLUSTER_CONFIG_BYTES, clusterConfig.toByteString());
        return this;
    }

    @Override
    public IKVRangeRestoreSession put(ByteString key, ByteString value) {
        this.restoreSession.put(key, value);
        return this;
    }
}

